/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.singleton;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.ejb.Singleton;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.ExcludeClassInterceptors;
import jakarta.interceptor.Interceptors;
import jakarta.interceptor.InvocationContext;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.openejb.test.SuperInterceptedBean;
import org.apache.openejb.test.interceptor.ClassInterceptor;
import org.apache.openejb.test.interceptor.Interceptor;
import org.apache.openejb.test.interceptor.MethodInterceptor;
import org.apache.openejb.test.singleton.BasicSingletonInterceptedLocal;
import org.apache.openejb.test.singleton.BasicSingletonInterceptedRemote;

@Singleton(name="BasicSingletonIntercepted")
@Interceptors(value={ClassInterceptor.class})
public class BasicSingletonInterceptedBean
extends SuperInterceptedBean
implements BasicSingletonInterceptedLocal,
BasicSingletonInterceptedRemote {
    private static Map<String, Object> contextData = new LinkedHashMap<String, Object>();

    @Override
    public String concat(String str1, String str2) {
        return str1.concat(str2);
    }

    @Override
    @Interceptors(value={MethodInterceptor.class})
    public String reverse(String str) {
        StringBuffer b = new StringBuffer(str);
        return b.reverse().toString();
    }

    private void setContextData(Map<String, Object> ctxData) {
        contextData.putAll(ctxData);
    }

    @Override
    @ExcludeClassInterceptors
    public Map<String, Object> getContextData() {
        return contextData;
    }

    @AroundInvoke
    public Object inBeanInterceptor(InvocationContext ctx) throws Exception {
        Map<String, Object> ctxData = Interceptor.profile(ctx, "inBeanInterceptor");
        this.setContextData(ctxData);
        return ctx.proceed();
    }

    @PostConstruct
    public void inBeanInterceptorPostConstruct() throws Exception {
        Map<String, Object> ctxData = Interceptor.profile(this, "inBeanInterceptorPostConstruct");
        this.setContextData(ctxData);
    }

    @PreDestroy
    public void inBeanInterceptorPreDestroy() throws Exception {
        Map<String, Object> ctxData = Interceptor.profile(this, "inBeanInterceptorPreDestroy");
        this.setContextData(ctxData);
    }
}

