/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.diskstore;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.devutils.diskstore.DebugPageManagerProvider;
import org.apache.wicket.devutils.diskstore.DiskStoreBrowserPage;
import org.apache.wicket.pageStore.DiskDataStore;
import org.apache.wicket.pageStore.PageWindowManager;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.lang.Bytes;

public class DebugDiskDataStore
extends DiskDataStore {
    public DebugDiskDataStore(String applicationName, File fileStoreFolder, Bytes maxSizePerSession) {
        super(applicationName, fileStoreFolder, maxSizePerSession);
    }

    public List<PageWindowManager.PageWindow> getLastPageWindows(String sessionId, int count) {
        ArrayList<PageWindowManager.PageWindow> pageWindows = new ArrayList<PageWindowManager.PageWindow>();
        DiskDataStore.SessionEntry sessionEntry = this.getSessionEntry(sessionId, false);
        if (sessionEntry != null) {
            PageWindowManager windowManager = sessionEntry.getManager();
            pageWindows.addAll(windowManager.getLastPageWindows(count));
        }
        return pageWindows;
    }

    public File getStoreFolder() {
        return super.getStoreFolder();
    }

    public static void register(Application application) {
        application.setPageManagerProvider((IPageManagerProvider)new DebugPageManagerProvider(application));
        ((WebApplication)application).mountPage("wicket/internal/debug/diskDataStore", DiskStoreBrowserPage.class);
    }
}

