/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.wizard;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.Wizard;
import org.apache.wicket.extensions.wizard.WizardButton;
import org.apache.wicket.extensions.wizard.WizardButtonBar;

public class AjaxWizardButtonBar
extends WizardButtonBar {
    private static final long serialVersionUID = 1L;

    public AjaxWizardButtonBar(String id, Wizard wizard) {
        super(id, wizard);
        wizard.setOutputMarkupId(true);
    }

    public MarkupContainer add(Component ... childs) {
        for (Component component : childs) {
            if (!(component instanceof WizardButton)) continue;
            this.ajaxify((WizardButton)component);
        }
        return super.add(childs);
    }

    private void ajaxify(final WizardButton button) {
        button.add(new Behavior[]{new AjaxFormSubmitBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxWizardButtonBar.this.updateAjaxAttributes(attributes);
            }

            public boolean getDefaultProcessing() {
                return button.getDefaultFormProcessing();
            }

            protected void onSubmit(AjaxRequestTarget target) {
                target.add(new Component[]{(Component)AjaxWizardButtonBar.this.findParent(Wizard.class)});
                button.onSubmit();
            }

            protected void onAfterSubmit(AjaxRequestTarget target) {
                button.onAfterSubmit();
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{(Component)AjaxWizardButtonBar.this.findParent(Wizard.class)});
                button.onError();
            }
        }});
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }
}

