/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.autocomplete;

import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractAutoCompleteRenderer<T>
implements IAutoCompleteRenderer<T> {
    private static final long serialVersionUID = 1L;

    @Override
    public void render(T object, Response response, String criteria) {
        String textValue = this.getTextValue(object);
        if (textValue == null) {
            throw new IllegalStateException("A call to textValue(Object) returned an illegal value: null for object: " + object.toString());
        }
        textValue = Strings.escapeMarkup((CharSequence)textValue).toString();
        response.write((CharSequence)("<li textvalue=\"" + textValue + "\""));
        CharSequence handler = this.getOnSelectJavaScriptExpression(object);
        if (handler != null) {
            response.write((CharSequence)(" onselect=\"" + handler + '\"'));
        }
        response.write((CharSequence)">");
        this.renderChoice(object, response, criteria);
        response.write((CharSequence)"</li>");
    }

    @Override
    public void renderHeader(Response response) {
        response.write((CharSequence)"<ul>");
    }

    @Override
    public void renderFooter(Response response, int count) {
        response.write((CharSequence)"</ul>");
    }

    protected abstract void renderChoice(T var1, Response var2, String var3);

    protected abstract String getTextValue(T var1);

    protected CharSequence getOnSelectJavaScriptExpression(T item) {
        return null;
    }
}

