/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.datetime;

import java.time.LocalTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.LocalTimeConverter;

public class LocalTimeTextField
extends TextField<LocalTime>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private final TextFormatConverter converter;

    public LocalTimeTextField(String id, IModel<LocalTime> model, final String timePattern) {
        super(id, model, LocalTime.class);
        this.converter = new TextFormatConverter(){
            private static final long serialVersionUID = 1L;

            public DateTimeFormatter getDateTimeFormatter(Locale locale) {
                return DateTimeFormatter.ofPattern(timePattern).withLocale(locale);
            }

            @Override
            public String getTextFormat(Locale locale) {
                return timePattern;
            }
        };
    }

    public LocalTimeTextField(String id, String datePattern) {
        this(id, null, datePattern);
    }

    public LocalTimeTextField(String id, IModel<LocalTime> model, final FormatStyle timeStyle) {
        super(id, model, LocalTime.class);
        this.converter = new TextFormatConverter(){
            private static final long serialVersionUID = 1L;

            public DateTimeFormatter getDateTimeFormatter(Locale locale) {
                return DateTimeFormatter.ofLocalizedTime(timeStyle).withLocale(locale);
            }

            @Override
            public String getTextFormat(Locale locale) {
                return DateTimeFormatterBuilder.getLocalizedDateTimePattern(null, timeStyle, IsoChronology.INSTANCE, locale);
            }
        };
    }

    public LocalTimeTextField(String id, FormatStyle timeStyle) {
        this(id, null, timeStyle);
    }

    protected IConverter<?> createConverter(Class<?> clazz) {
        if (LocalTime.class.isAssignableFrom(clazz)) {
            return this.converter;
        }
        return null;
    }

    public final String getTextFormat() {
        return this.converter.getTextFormat(this.getLocale());
    }

    private abstract class TextFormatConverter
    extends LocalTimeConverter {
        private static final long serialVersionUID = 1L;

        private TextFormatConverter() {
        }

        public abstract String getTextFormat(Locale var1);
    }
}

