/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.spring.FieldBeansCollector;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.ResolvableType;

public class SpringBeanLocator
implements IProxyTargetLocator {
    private static final long serialVersionUID = 1L;
    private transient WeakReference<Class<?>> beanTypeCache;
    private final String beanTypeName;
    private String beanName;
    private ISpringContextLocator springContextLocator;
    private Boolean singletonCache = null;
    private ResolvableType fieldResolvableType;
    private ResolvableType fieldElementsResolvableType;

    public SpringBeanLocator(Class<?> beanType, ISpringContextLocator locator) {
        this(null, beanType, null, locator);
    }

    public SpringBeanLocator(String beanName, Class<?> beanType, ISpringContextLocator locator) {
        this(beanName, beanType, null, locator);
    }

    public SpringBeanLocator(Class<?> beanType, Field beanField, ISpringContextLocator locator) {
        this(null, beanType, beanField, locator);
    }

    public SpringBeanLocator(String beanName, Class<?> beanType, Field beanField, ISpringContextLocator locator) {
        Args.notNull((Object)locator, (String)"locator");
        Args.notNull(beanType, (String)"beanType");
        this.beanName = beanName;
        this.beanTypeCache = new WeakReference(beanType);
        this.beanTypeName = beanType.getName();
        this.springContextLocator = locator;
        if (beanField != null) {
            this.fieldResolvableType = ResolvableType.forField((Field)beanField);
            this.fieldElementsResolvableType = this.extractElementGeneric(this.fieldResolvableType);
        }
    }

    private ResolvableType extractElementGeneric(ResolvableType fieldResolvableType) {
        Class clazz = fieldResolvableType.resolve();
        if (Set.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz)) {
            return fieldResolvableType.getGeneric(new int[0]);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return fieldResolvableType.getGeneric(new int[]{1});
        }
        return null;
    }

    public boolean isSingletonBean() {
        if (this.singletonCache == null) {
            this.singletonCache = this.getBeanName() != null && this.getSpringContext().isSingleton(this.getBeanName());
        }
        return this.singletonCache;
    }

    public Class<?> getBeanType() {
        Class clazz;
        Class clazz2 = clazz = this.beanTypeCache == null ? null : (Class)this.beanTypeCache.get();
        if (clazz == null) {
            clazz = WicketObjects.resolveClass((String)this.beanTypeName);
            this.beanTypeCache = new WeakReference<Class>(clazz);
            if (clazz == null) {
                throw new RuntimeException("SpringBeanLocator could not find class [" + this.beanTypeName + "] needed to locate the [" + (this.beanName != null ? this.beanName : "bean name not specified") + "] bean");
            }
        }
        return clazz;
    }

    public Object locateProxyTarget() {
        ApplicationContext context = this.getSpringContext();
        return this.lookupSpringBean(context, this.beanName, this.getBeanType());
    }

    private ApplicationContext getSpringContext() {
        ApplicationContext context = this.springContextLocator.getSpringContext();
        if (context == null) {
            throw new IllegalStateException("spring application context locator returned null");
        }
        return context;
    }

    public final String getBeanName() {
        return this.beanName;
    }

    public final ISpringContextLocator getSpringContextLocator() {
        return this.springContextLocator;
    }

    private Object lookupSpringBean(ApplicationContext ctx, String name, Class<?> clazz) {
        try {
            if (name != null) {
                return ctx.getBean(name, clazz);
            }
            if (this.fieldResolvableType == null) {
                return ctx.getBean(clazz);
            }
            Class lookupClass = this.fieldElementsResolvableType != null ? this.fieldElementsResolvableType.resolve() : clazz;
            List<String> names = this.loadBeanNames(ctx, lookupClass);
            Object foundBeans = this.getBeansByName(ctx, names);
            if (foundBeans != null) {
                return foundBeans;
            }
            throw new IllegalStateException("Concrete bean could not be received from the application context for class: " + clazz.getName() + ".");
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalStateException("bean with name [" + name + "] and class [" + clazz.getName() + "] not found", e);
        }
    }

    private List<String> loadBeanNames(ApplicationContext ctx, Class<?> lookupClass) {
        ArrayList<String> beanNames = new ArrayList<String>();
        Class<?> fieldType = this.getBeanType();
        String[] beanNamesArr = ctx.getBeanNamesForType(fieldType);
        beanNames.addAll(Arrays.asList(beanNamesArr));
        if (lookupClass != fieldType) {
            beanNamesArr = ctx.getBeanNamesForType(lookupClass);
            beanNames.addAll(Arrays.asList(beanNamesArr));
        }
        Iterator nameIterator = beanNames.iterator();
        while (nameIterator.hasNext()) {
            if (ctx.containsBeanDefinition((String)nameIterator.next())) continue;
            nameIterator.remove();
        }
        return beanNames;
    }

    private Object getBeansByName(ApplicationContext ctx, List<String> names) {
        FieldBeansCollector beansCollector = new FieldBeansCollector(this.fieldResolvableType);
        for (String beanName : names) {
            boolean elementMatch;
            RootBeanDefinition beanDef = this.getBeanDefinition(ctx, beanName);
            if (beanDef == null) continue;
            ResolvableType candidateResolvableType = null;
            if (beanDef.hasBeanClass()) {
                candidateResolvableType = ResolvableType.forClass((Class)beanDef.getBeanClass());
            } else if (beanDef.getResolvedFactoryMethod() != null) {
                candidateResolvableType = ResolvableType.forMethodReturnType((Method)beanDef.getResolvedFactoryMethod());
            }
            if (candidateResolvableType == null) continue;
            boolean exactMatch = this.fieldResolvableType.isAssignableFrom(candidateResolvableType);
            boolean bl = elementMatch = this.fieldElementsResolvableType != null && this.fieldElementsResolvableType.isAssignableFrom(candidateResolvableType);
            if (exactMatch) {
                this.beanName = beanName;
                return ctx.getBean(beanName);
            }
            if (!elementMatch) continue;
            beansCollector.addBean(beanName, ctx.getBean(beanName));
        }
        return beansCollector.getBeansToInject();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpringBeanLocator) {
            SpringBeanLocator other = (SpringBeanLocator)obj;
            return this.beanTypeName.equals(other.beanTypeName) && Objects.equal((Object)this.beanName, (Object)other.beanName);
        }
        return false;
    }

    public int hashCode() {
        int hashcode = this.beanTypeName.hashCode();
        if (this.getBeanName() != null) {
            hashcode += 127 * this.beanName.hashCode();
        }
        return hashcode;
    }

    public RootBeanDefinition getBeanDefinition(ApplicationContext ctx, String name) {
        BeanDefinition beanDef;
        ConfigurableListableBeanFactory beanFactory = ((AbstractApplicationContext)ctx).getBeanFactory();
        BeanDefinition beanDefinition = beanDef = beanFactory.containsBean(name) ? beanFactory.getMergedBeanDefinition(name) : null;
        if (beanDef instanceof RootBeanDefinition) {
            return (RootBeanDefinition)beanDef;
        }
        return null;
    }
}

