/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HandleArrayListStack<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;

    public HandleArrayListStack() {
        this(10);
    }

    public HandleArrayListStack(Collection<? extends T> collection) {
        super(collection);
    }

    public HandleArrayListStack(int initialCapacity) {
        super(initialCapacity);
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    @Override
    public int indexOf(Object elem) {
        int size = this.size();
        if (elem == null) {
            for (int i = 0; i < size; ++i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (elem != this.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (elem != this.get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public final T peek() {
        int size = this.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return (T)this.get(size - 1);
    }

    public final T pop() {
        T top = this.peek();
        this.remove(this.size() - 1);
        return top;
    }

    public final void push(T item) {
        this.add(item);
    }

    public final int search(Object o) {
        int i = this.lastIndexOf(o);
        if (i >= 0) {
            return this.size() - i;
        }
        return -1;
    }
}

