/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.wicket.util.time.AbstractTime;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.TimeOfDay;

public final class Time
extends AbstractTime {
    private static final long serialVersionUID = 1L;
    public static final Time START_OF_UNIX_TIME = Time.millis(0L);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd", Locale.ENGLISH);
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy.MM.dd-h.mma", Locale.ENGLISH);
    private static final String[] DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    public static Time now() {
        return Time.millis(System.currentTimeMillis());
    }

    public static Time millis(long time) {
        return new Time(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time parseDate(Calendar calendar, String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                dateFormat.setCalendar(calendar);
                return Time.valueOf(dateFormat.parse(string));
            }
        }
    }

    public static Time parseDate(String string) throws ParseException {
        return Time.parseDate(localtime, string);
    }

    public static Time valueOf(long time) {
        return Time.millis(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time valueOf(Calendar calendar, String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = dateTimeFormat;
        synchronized (simpleDateFormat) {
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                dateTimeFormat.setCalendar(calendar);
                return Time.valueOf(dateTimeFormat.parse(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time valueOf(Calendar calendar, TimeOfDay timeOfDay) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return Time.millis(calendar.getTimeInMillis() + timeOfDay.getMilliseconds());
        }
    }

    public static Time valueOf(Date date) {
        return new Time(date.getTime());
    }

    public static Time valueOf(String string) throws ParseException {
        return Time.valueOf(localtime, string);
    }

    public static Time valueOf(String string, String pattern) throws ParseException {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(pattern, Locale.ENGLISH);
        dateTimeFormat.setCalendar(localtime);
        return Time.valueOf(dateTimeFormat.parse(string));
    }

    public static Time valueOf(TimeOfDay timeOfDay) {
        return Time.valueOf(localtime, timeOfDay);
    }

    private Time(long time) {
        super(time);
    }

    public Time add(Duration duration) {
        return Time.millis(this.getMilliseconds() + duration.getMilliseconds());
    }

    public Duration elapsedSince() {
        Time now = Time.now();
        if (this.greaterThan(now)) {
            throw new IllegalStateException("This time is in the future");
        }
        return now.subtract(this);
    }

    public Duration fromNow() {
        return this.subtract(Time.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(Calendar calendar, int field) {
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(this.getMilliseconds());
            return calendar.get(field);
        }
    }

    public int get(int field) {
        return this.get(localtime, field);
    }

    public int getDayOfMonth() {
        return this.getDayOfMonth(localtime);
    }

    public int getDayOfMonth(Calendar calendar) {
        return this.get(calendar, 5);
    }

    public int getHour() {
        return this.getHour(localtime);
    }

    public int getHour(Calendar calendar) {
        return this.get(calendar, 10);
    }

    public int getMinute() {
        return this.getMinute(localtime);
    }

    public int getMinute(Calendar calendar) {
        return this.get(calendar, 12);
    }

    public int getMonth() {
        return this.getMonth(localtime);
    }

    public int getMonth(Calendar calendar) {
        return this.get(calendar, 2);
    }

    public int getSecond() {
        return this.getSecond(localtime);
    }

    public int getSecond(Calendar calendar) {
        return this.get(calendar, 13);
    }

    public int getYear() {
        return this.getYear(localtime);
    }

    public int getYear(Calendar calendar) {
        return this.get(calendar, 1);
    }

    public Time subtract(Duration duration) {
        return Time.millis(this.getMilliseconds() - duration.getMilliseconds());
    }

    public Duration subtract(Time that) {
        return Duration.milliseconds(this.getMilliseconds() - that.getMilliseconds());
    }

    public Date toDate() {
        return new Date(this.getMilliseconds());
    }

    public String toDateString() {
        return this.toDateString(localtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDateString(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                dateFormat.setCalendar(calendar);
                return dateFormat.format(new Date(this.getMilliseconds())).toLowerCase();
            }
        }
    }

    public String toString() {
        return this.toDateString() + "-" + this.toTimeString();
    }

    public String toString(Calendar calendar, String format) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(format, Locale.ENGLISH);
        dateTimeFormat.setCalendar(calendar == null ? localtime : calendar);
        return dateTimeFormat.format(new Date(this.getMilliseconds()));
    }

    public String toString(String format) {
        return this.toString(null, format);
    }

    public String toRfc1123TimestampString() {
        Calendar cal = GregorianCalendar.getInstance(GMT);
        StringBuilder buf = new StringBuilder(32);
        cal.setTimeInMillis(this.getMilliseconds());
        int day_of_week = cal.get(7);
        int day_of_month = cal.get(5);
        int month = cal.get(2);
        int year = cal.get(1);
        int century = year / 100;
        year %= 100;
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        buf.append(DAYS[day_of_week]);
        buf.append(',');
        buf.append(' ');
        Time.appendTwoDigits(buf, day_of_month);
        buf.append(' ');
        buf.append(MONTHS[month]);
        buf.append(' ');
        Time.appendTwoDigits(buf, century);
        Time.appendTwoDigits(buf, year);
        buf.append(' ');
        Time.appendTwoDigits(buf, hours);
        buf.append(':');
        Time.appendTwoDigits(buf, minutes);
        buf.append(':');
        Time.appendTwoDigits(buf, seconds);
        buf.append(" GMT");
        return buf.toString();
    }

    private static void appendTwoDigits(StringBuilder str, int number) {
        str.append((char)(number / 10 + 48));
        str.append((char)(number % 10 + 48));
    }
}

