/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class Checks {
    public static void notNull(Object argument, String message, Object ... params) {
        if (argument == null) {
            throw new IllegalStateException(Args.format(message, params));
        }
    }

    public static void notEmpty(String argument, String message, Object ... params) {
        if (Strings.isEmpty(argument)) {
            throw new IllegalStateException(Args.format(message, params));
        }
    }

    public static <T extends Comparable<? super T>> void withinRange(T min, T max, T value, String message) {
        Checks.notNull(min, message, new Object[0]);
        Checks.notNull(max, message, new Object[0]);
        if (value.compareTo(min) < 0 || value.compareTo(max) > 0) {
            throw new IllegalStateException(message);
        }
    }

    public static void notNullShort(Object argument, String name) {
        Checks.notNull(argument, name + " may not be null.", new Object[0]);
    }

    public static void notEmptyShort(String argument, String name) {
        Checks.notEmpty(argument, name + " may not be null or empty string.", new Object[0]);
    }

    public static <T extends Comparable<? super T>> void withinRangeShort(T min, T max, T value, String name) {
        Checks.withinRange(min, max, value, String.format("%s must have a value within [%s,%s], but was %s", name, min, max, value));
    }
}

