/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.truth.xml;

import org.apache.axiom.truth.xml.Filter;
import org.apache.axiom.truth.xml.spi.Event;
import org.apache.axiom.truth.xml.spi.Traverser;
import org.apache.axiom.truth.xml.spi.TraverserException;

final class CoalescingFilter
extends Filter {
    private Event savedEvent;
    private String savedText;

    CoalescingFilter(Traverser parent) {
        super(parent);
    }

    @Override
    public Event next() throws TraverserException {
        this.savedText = null;
        if (this.savedEvent != null) {
            Event event = this.savedEvent;
            this.savedEvent = null;
            return event;
        }
        Event event = super.next();
        if (event == Event.TEXT || event == Event.WHITESPACE) {
            Event nextEvent;
            String text = super.getText();
            StringBuilder buffer = null;
            while ((nextEvent = super.next()) == event) {
                if (buffer == null) {
                    buffer = new StringBuilder(text);
                }
                buffer.append(super.getText());
            }
            this.savedEvent = nextEvent;
            this.savedText = buffer == null ? text : buffer.toString();
        }
        return event;
    }

    @Override
    public String getText() {
        return this.savedText != null ? this.savedText : super.getText();
    }
}

