/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.web.support.CookieValueManager;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCasCookieValueManager
implements CookieValueManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasCookieValueManager.class);
    private static final char COOKIE_FIELD_SEPARATOR = '@';
    private static final int COOKIE_FIELDS_LENGTH = 3;
    private final CipherExecutor<Serializable, Serializable> cipherExecutor;

    public DefaultCasCookieValueManager(CipherExecutor cipherExecutor) {
        this.cipherExecutor = cipherExecutor;
    }

    @Override
    public String buildCookieValue(String givenCookieValue, HttpServletRequest request) {
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        StringBuilder builder = new StringBuilder(givenCookieValue).append('@').append(clientInfo.getClientIpAddress());
        String userAgent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            throw new IllegalStateException("Request does not specify a user-agent");
        }
        builder.append('@').append(userAgent);
        String res = builder.toString();
        LOGGER.debug("Encoding cookie value [{}]", (Object)res);
        return ((Serializable)this.cipherExecutor.encode((Object)res)).toString();
    }

    @Override
    public String obtainCookieValue(Cookie cookie, HttpServletRequest request) {
        String cookieValue = ((Serializable)this.cipherExecutor.decode((Object)cookie.getValue())).toString();
        LOGGER.debug("Decoded cookie value is [{}]", (Object)cookieValue);
        if (StringUtils.isBlank((CharSequence)cookieValue)) {
            LOGGER.debug("Retrieved decoded cookie value is blank. Failed to decode cookie [{}]", (Object)cookie.getName());
            return null;
        }
        String[] cookieParts = cookieValue.split(String.valueOf('@'));
        if (cookieParts.length != 3) {
            throw new IllegalStateException("Invalid cookie. Required fields are missing");
        }
        String value = cookieParts[0];
        String remoteAddr = cookieParts[1];
        String userAgent = cookieParts[2];
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)remoteAddr) || StringUtils.isBlank((CharSequence)userAgent)) {
            throw new IllegalStateException("Invalid cookie. Required fields are empty");
        }
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (!remoteAddr.equals(clientInfo.getClientIpAddress())) {
            throw new IllegalStateException("Invalid cookie. Required remote address " + remoteAddr + " does not match " + clientInfo.getClientIpAddress());
        }
        String agent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        if (!userAgent.equals(agent)) {
            throw new IllegalStateException("Invalid cookie. Required user-agent " + userAgent + " does not match " + agent);
        }
        return value;
    }
}

