/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.hazelcast.BaseHazelcastProperties;
import org.apereo.cas.configuration.model.support.hazelcast.HazelcastTicketRegistryProperties;
import org.apereo.cas.hz.HazelcastConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casHazelcastConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasHazelcastConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasHazelcastConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"casHazelcastInstance"})
    @Bean
    public HazelcastInstance casHazelcastInstance() {
        HazelcastTicketRegistryProperties hz = this.casProperties.getTicket().getRegistry().getHazelcast();
        LOGGER.debug("Creating Hazelcast instance using properties [{}]", (Object)hz);
        HazelcastConfigurationFactory factory = new HazelcastConfigurationFactory();
        return Hazelcast.newHazelcastInstance((Config)factory.build((BaseHazelcastProperties)hz));
    }
}

