/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.DatabaseProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigDataHolder;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.services.AbstractRegisteredService;
import org.apereo.cas.services.JpaServiceRegistry;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlan;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration(value="jpaServiceRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=true)
public class JpaServiceRegistryConfiguration
implements ServiceRegistryExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaServiceRegistryConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    public HibernateJpaVendorAdapter jpaServiceVendorAdapter() {
        return JpaBeans.newHibernateJpaVendorAdapter((DatabaseProperties)this.casProperties.getJdbc());
    }

    @Bean
    public List<String> jpaServicePackagesToScan() {
        Reflections reflections = new Reflections((org.reflections.Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)CentralAuthenticationService.NAMESPACE, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(false)}));
        Set subTypes = reflections.getSubTypesOf(AbstractRegisteredService.class);
        return subTypes.stream().map(t -> t.getPackage().getName()).collect(Collectors.toList());
    }

    @Lazy
    @Bean
    public LocalContainerEntityManagerFactoryBean serviceEntityManagerFactory() {
        return JpaBeans.newHibernateEntityManagerFactoryBean((JpaConfigDataHolder)new JpaConfigDataHolder((JpaVendorAdapter)this.jpaServiceVendorAdapter(), "jpaServiceRegistryContext", this.jpaServicePackagesToScan(), this.dataSourceService()), (AbstractJpaProperties)this.casProperties.getServiceRegistry().getJpa());
    }

    @Autowired
    @Bean
    public PlatformTransactionManager transactionManagerServiceReg(@Qualifier(value="serviceEntityManagerFactory") EntityManagerFactory emf) {
        JpaTransactionManager mgmr = new JpaTransactionManager();
        mgmr.setEntityManagerFactory(emf);
        return mgmr;
    }

    @Bean
    public DataSource dataSourceService() {
        return JpaBeans.newDataSource((AbstractJpaProperties)this.casProperties.getServiceRegistry().getJpa());
    }

    @Bean
    @RefreshScope
    public ServiceRegistry jpaServiceRegistry() {
        return new JpaServiceRegistry();
    }

    public void configureServiceRegistry(ServiceRegistryExecutionPlan plan) {
        plan.registerServiceRegistry(this.jpaServiceRegistry());
    }
}

