/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.model.support.mongo.serviceregistry.MongoDbServiceRegistryProperties;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.services.MongoDbServiceRegistry;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlan;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration(value="mongoDbServiceRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class MongoDbServiceRegistryConfiguration
implements ServiceRegistryExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbServiceRegistryConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"mongoDbServiceRegistryTemplate"})
    @Bean
    public MongoTemplate mongoDbServiceRegistryTemplate() {
        MongoDbServiceRegistryProperties mongo = this.casProperties.getServiceRegistry().getMongo();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory();
        MongoTemplate mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongo);
        factory.createCollection((MongoOperations)mongoTemplate, mongo.getCollection(), mongo.isDropCollection());
        return mongoTemplate;
    }

    @Bean
    public ServiceRegistry mongoDbServiceRegistry() {
        MongoDbServiceRegistryProperties mongo = this.casProperties.getServiceRegistry().getMongo();
        return new MongoDbServiceRegistry((MongoOperations)this.mongoDbServiceRegistryTemplate(), mongo.getCollection());
    }

    public void configureServiceRegistry(ServiceRegistryExecutionPlan plan) {
        plan.registerServiceRegistry(this.mongoDbServiceRegistry());
    }
}

