/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.events.service.CasRegisteredServiceLoadedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDbServiceRegistry
extends AbstractServiceRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbServiceRegistry.class);
    private final MongoOperations mongoTemplate;
    private final String collectionName;

    public boolean delete(RegisteredService svc) {
        if (this.findServiceById(svc.getId()) != null) {
            this.mongoTemplate.remove((Object)svc, this.collectionName);
            LOGGER.debug("Removed registered service: [{}]", (Object)svc);
            return true;
        }
        return false;
    }

    public RegisteredService findServiceById(long svcId) {
        return (RegisteredService)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)svcId)), RegisteredService.class, this.collectionName);
    }

    public RegisteredService findServiceById(String id) {
        Pattern pattern = Pattern.compile(id, 2);
        return (RegisteredService)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"serviceId").regex(pattern)), RegisteredService.class, this.collectionName);
    }

    public List<RegisteredService> load() {
        List list = this.mongoTemplate.findAll(RegisteredService.class, this.collectionName);
        list.forEach(s -> this.publishEvent((ApplicationEvent)new CasRegisteredServiceLoadedEvent((Object)this, s)));
        return list;
    }

    public RegisteredService save(RegisteredService svc) {
        if (svc.getId() == -1L) {
            svc.setId((long)svc.hashCode());
        }
        this.mongoTemplate.save((Object)svc, this.collectionName);
        LOGGER.debug("Saved registered service: [{}]", (Object)svc);
        return this.findServiceById(svc.getId());
    }

    public long size() {
        return this.mongoTemplate.count(new Query(), RegisteredService.class, this.collectionName);
    }

    @Generated
    public String toString() {
        return "MongoDbServiceRegistry(mongoTemplate=" + this.mongoTemplate + ", collectionName=" + this.collectionName + ")";
    }

    @Generated
    public MongoDbServiceRegistry(MongoOperations mongoTemplate, String collectionName) {
        this.mongoTemplate = mongoTemplate;
        this.collectionName = collectionName;
    }
}

