/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class OAuthAccessTokenExpirationPolicy
extends AbstractCasExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthAccessTokenExpirationPolicy.class);
    private static final long serialVersionUID = -8383186650682727360L;
    private long maxTimeToLiveInSeconds;
    private long timeToKillInSeconds;

    @JsonCreator
    public OAuthAccessTokenExpirationPolicy(@JsonProperty(value="timeToLive") long maxTimeToLive, @JsonProperty(value="timeToIdle") long timeToKill) {
        this.maxTimeToLiveInSeconds = maxTimeToLive;
        this.timeToKillInSeconds = timeToKill;
    }

    public boolean isExpired(TicketState ticketState) {
        boolean expired = this.isAccessTokenExpired(ticketState);
        if (!expired) {
            return super.isExpired(ticketState);
        }
        return expired;
    }

    public Long getTimeToLive() {
        return this.maxTimeToLiveInSeconds;
    }

    public Long getTimeToIdle() {
        return this.timeToKillInSeconds;
    }

    @JsonIgnore
    protected boolean isAccessTokenExpired(TicketState ticketState) {
        ZonedDateTime creationTime;
        ZonedDateTime expirationTime;
        ZonedDateTime currentSystemTime = ZonedDateTime.now(ZoneOffset.UTC);
        if (currentSystemTime.isAfter(expirationTime = (creationTime = ticketState.getCreationTime()).plus(this.maxTimeToLiveInSeconds, ChronoUnit.SECONDS))) {
            LOGGER.debug("Access token is expired because the time since creation is greater than maxTimeToLiveInSeconds");
            return true;
        }
        expirationTime = ticketState.getLastTimeUsed().plus(this.timeToKillInSeconds, ChronoUnit.SECONDS);
        if (currentSystemTime.isAfter(expirationTime)) {
            LOGGER.debug("Access token is expired because the time since last use is greater than timeToKillInSeconds");
            return true;
        }
        return false;
    }

    @Generated
    public OAuthAccessTokenExpirationPolicy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthAccessTokenExpirationPolicy)) {
            return false;
        }
        OAuthAccessTokenExpirationPolicy other = (OAuthAccessTokenExpirationPolicy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.maxTimeToLiveInSeconds != other.maxTimeToLiveInSeconds) {
            return false;
        }
        return this.timeToKillInSeconds == other.timeToKillInSeconds;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuthAccessTokenExpirationPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $maxTimeToLiveInSeconds = this.maxTimeToLiveInSeconds;
        result = result * 59 + (int)($maxTimeToLiveInSeconds >>> 32 ^ $maxTimeToLiveInSeconds);
        long $timeToKillInSeconds = this.timeToKillInSeconds;
        result = result * 59 + (int)($timeToKillInSeconds >>> 32 ^ $timeToKillInSeconds);
        return result;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    public static class OAuthAccessTokenSovereignExpirationPolicy
    extends OAuthAccessTokenExpirationPolicy {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(OAuthAccessTokenSovereignExpirationPolicy.class);
        private static final long serialVersionUID = -7768661082888351104L;

        @JsonCreator
        public OAuthAccessTokenSovereignExpirationPolicy(@JsonProperty(value="timeToLive") long maxTimeToLive, @JsonProperty(value="timeToIdle") long timeToKill) {
            super(maxTimeToLive, timeToKill);
        }

        @Override
        public boolean isExpired(TicketState ticketState) {
            return this.isAccessTokenExpired(ticketState);
        }

        @Generated
        public OAuthAccessTokenSovereignExpirationPolicy() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OAuthAccessTokenSovereignExpirationPolicy)) {
                return false;
            }
            OAuthAccessTokenSovereignExpirationPolicy other = (OAuthAccessTokenSovereignExpirationPolicy)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OAuthAccessTokenSovereignExpirationPolicy;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }
}

