/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.pm.InvalidPasswordException;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PasswordChangeAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordChangeAction.class);
    public static final String PASSWORD_UPDATE_SUCCESS = "passwordUpdateSuccess";
    private static final String PASSWORD_VALIDATION_FAILURE_CODE = "pm.validationFailure";
    private static final String DEFAULT_MESSAGE = "Could not update the account password";
    private final PasswordManagementService passwordManagementService;
    private final PasswordValidationService passwordValidationService;
    private final CommunicationsManager communicationsManager;

    protected Event doExecute(RequestContext requestContext) {
        try {
            UsernamePasswordCredential c = Objects.requireNonNull((UsernamePasswordCredential)WebUtils.getCredential((RequestContext)requestContext, UsernamePasswordCredential.class));
            PasswordChangeRequest bean = this.getPasswordChangeRequest(requestContext, c);
            LOGGER.debug("Attempting to validate the password change bean for username [{}]", (Object)c.getUsername());
            if (!this.passwordValidationService.isValid(c, bean)) {
                LOGGER.error("Failed to validate the provided password");
                return this.getErrorEvent(requestContext, PASSWORD_VALIDATION_FAILURE_CODE, DEFAULT_MESSAGE, new Object[0]);
            }
            if (this.passwordManagementService.change((Credential)c, bean)) {
                WebUtils.putCredential((RequestContext)requestContext, (Credential)new UsernamePasswordCredential(c.getUsername(), bean.getPassword()));
                return new EventFactorySupport().event((Object)this, PASSWORD_UPDATE_SUCCESS);
            }
        }
        catch (InvalidPasswordException e) {
            return this.getErrorEvent(requestContext, PASSWORD_VALIDATION_FAILURE_CODE + (String)StringUtils.defaultIfBlank((CharSequence)e.getCode(), (CharSequence)""), (String)StringUtils.defaultIfBlank((CharSequence)e.getValidationMessage(), (CharSequence)DEFAULT_MESSAGE), e.getParams());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return this.getErrorEvent(requestContext, "pm.updateFailure", DEFAULT_MESSAGE, new Object[0]);
    }

    protected PasswordChangeRequest getPasswordChangeRequest(RequestContext requestContext, UsernamePasswordCredential c) {
        PasswordChangeRequest bean = (PasswordChangeRequest)requestContext.getFlowScope().get("password", PasswordChangeRequest.class);
        bean.setUsername(c.getUsername());
        return bean;
    }

    private Event getErrorEvent(RequestContext ctx, String code, String message, Object ... params) {
        ctx.getMessageContext().addMessage(new MessageBuilder().error().code(code).defaultText(message).args(params).build());
        return this.error();
    }

    @Generated
    public PasswordChangeAction(PasswordManagementService passwordManagementService, PasswordValidationService passwordValidationService, CommunicationsManager communicationsManager) {
        this.passwordManagementService = passwordManagementService;
        this.passwordValidationService = passwordValidationService;
        this.communicationsManager = communicationsManager;
    }
}

