/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendForgotUsernameInstructionsAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SendForgotUsernameInstructionsAction.class);
    protected final CasConfigurationProperties casProperties;
    protected final CommunicationsManager communicationsManager;
    protected final PasswordManagementService passwordManagementService;

    protected Event doExecute(RequestContext requestContext) {
        this.communicationsManager.validate();
        if (!this.communicationsManager.isMailSenderDefined()) {
            return this.getErrorEvent("email.failed", "Unable to send email as no mail sender is defined", requestContext);
        }
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String email = request.getParameter("email");
        if (StringUtils.isBlank((CharSequence)email)) {
            return this.getErrorEvent("email.required", "No email is provided", requestContext);
        }
        if (!EmailValidator.getInstance().isValid(email)) {
            return this.getErrorEvent("email.invalid", "Provided email address is invalid", requestContext);
        }
        String username = this.passwordManagementService.findUsername(email);
        if (StringUtils.isBlank((CharSequence)username)) {
            return this.getErrorEvent("username.missing", "No username could be located for the given email address", requestContext);
        }
        if (this.sendForgotUsernameEmailToAccount(email, username)) {
            return this.success();
        }
        return this.getErrorEvent("username.failed", "Failed to send the username to the given email address", requestContext);
    }

    private boolean sendForgotUsernameEmailToAccount(String email, String username) {
        EmailProperties reset = this.casProperties.getAuthn().getPm().getForgotUsername().getMail();
        String text = reset.getFormattedBody(new Object[]{username});
        return this.communicationsManager.email(reset, email, text);
    }

    private Event getErrorEvent(String code, String defaultMessage, RequestContext requestContext) {
        MessageContext messages = requestContext.getMessageContext();
        messages.addMessage(new MessageBuilder().error().code("screen.pm.forgotusername." + code).build());
        LOGGER.error(defaultMessage);
        return new EventFactorySupport().event((Object)this, "error");
    }

    @Generated
    public SendForgotUsernameInstructionsAction(CasConfigurationProperties casProperties, CommunicationsManager communicationsManager, PasswordManagementService passwordManagementService) {
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
        this.passwordManagementService = passwordManagementService;
    }
}

