/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.web.util.UriUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendPasswordResetInstructionsAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SendPasswordResetInstructionsAction.class);
    protected final CasConfigurationProperties casProperties;
    protected final CommunicationsManager communicationsManager;
    protected final PasswordManagementService passwordManagementService;
    protected final TicketRegistry ticketRegistry;
    protected final TicketFactory ticketFactory;

    public String buildPasswordResetUrl(String username, PasswordManagementService passwordManagementService, CasConfigurationProperties casProperties, WebApplicationService service) {
        String token = passwordManagementService.createToken(username);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            TransientSessionTicketFactory transientFactory = (TransientSessionTicketFactory)this.ticketFactory.get(TransientSessionTicket.class);
            Map properties = CollectionUtils.wrap((String)"token", (Object)token);
            TransientSessionTicket ticket = transientFactory.create((Service)service, properties);
            this.ticketRegistry.addTicket((Ticket)ticket);
            StringBuilder resetUrl = new StringBuilder(casProperties.getServer().getPrefix()).append('/').append("login").append('?').append("pswdrst").append('=').append(ticket.getId());
            if (service != null) {
                String encodeServiceUrl = UriUtils.encode((String)service.getOriginalUrl(), (Charset)StandardCharsets.UTF_8);
                resetUrl.append('&').append("service").append('=').append(encodeServiceUrl);
            }
            String url = resetUrl.toString();
            LOGGER.debug("Final password reset URL designed for [{}] is [{}]", (Object)username, (Object)url);
            return url;
        }
        LOGGER.error("Could not create password reset url since no reset token could be generated");
        return null;
    }

    protected Event doExecute(RequestContext requestContext) {
        this.communicationsManager.validate();
        if (!this.communicationsManager.isMailSenderDefined() && !this.communicationsManager.isSmsSenderDefined()) {
            return this.getErrorEvent("contact.failed", "Unable to send email as no mail sender is defined", requestContext);
        }
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String username = request.getParameter("username");
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.warn("No username parameter is provided");
            return this.getErrorEvent("username.required", "No username is provided", requestContext);
        }
        String email = this.passwordManagementService.findEmail(username);
        String phone = this.passwordManagementService.findPhone(username);
        if (StringUtils.isBlank((CharSequence)email) && StringUtils.isBlank((CharSequence)phone)) {
            LOGGER.warn("No recipient is provided with a valid email/phone");
            return this.getErrorEvent("contact.invalid", "Provided email address or phone number is invalid", requestContext);
        }
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        String url = this.buildPasswordResetUrl(username, this.passwordManagementService, this.casProperties, service);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
            LOGGER.debug("Generated password reset URL [{}]; Link is only active for the next [{}] minute(s)", (Object)url, (Object)pm.getReset().getExpirationMinutes());
            if (this.sendPasswordResetEmailToAccount(email, url) || this.sendPasswordResetSmsToAccount(phone, url)) {
                return this.success();
            }
        } else {
            LOGGER.error("No password reset URL could be built and sent to [{}]", (Object)email);
        }
        LOGGER.error("Failed to notify account [{}]", (Object)email);
        return this.getErrorEvent("contact.failed", "Failed to send the password reset link to the given email address or phone number", requestContext);
    }

    protected boolean sendPasswordResetSmsToAccount(String to, String url) {
        if (StringUtils.isNotBlank((CharSequence)to)) {
            LOGGER.debug("Sending password reset URL [{}] via SMS to [{}]", (Object)url, (Object)to);
            SmsProperties reset = this.casProperties.getAuthn().getPm().getReset().getSms();
            String message = reset.getFormattedText(new Object[]{url});
            return this.communicationsManager.sms(reset.getFrom(), to, message);
        }
        return false;
    }

    protected boolean sendPasswordResetEmailToAccount(String to, String url) {
        if (StringUtils.isNotBlank((CharSequence)to)) {
            EmailProperties reset = this.casProperties.getAuthn().getPm().getReset().getMail();
            String text = reset.getFormattedBody(new Object[]{url});
            LOGGER.debug("Sending password reset URL [{}] via email to [{}]", (Object)url, (Object)to);
            return this.communicationsManager.email(reset, to, text);
        }
        return false;
    }

    protected Event getErrorEvent(String code, String defaultMessage, RequestContext requestContext) {
        MessageContext messages = requestContext.getMessageContext();
        messages.addMessage(new MessageBuilder().error().code("screen.pm.reset." + code).build());
        LOGGER.error(defaultMessage);
        return new EventFactorySupport().event((Object)this, "error");
    }

    @Generated
    public SendPasswordResetInstructionsAction(CasConfigurationProperties casProperties, CommunicationsManager communicationsManager, PasswordManagementService passwordManagementService, TicketRegistry ticketRegistry, TicketFactory ticketFactory) {
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
        this.passwordManagementService = passwordManagementService;
        this.ticketRegistry = ticketRegistry;
        this.ticketFactory = ticketFactory;
    }
}

