/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.services.BaseSurrogateRegisteredServiceAccessStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurrogateRegisteredServiceAccessStrategy
extends BaseSurrogateRegisteredServiceAccessStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateRegisteredServiceAccessStrategy.class);
    private static final long serialVersionUID = -1688944419711632962L;
    private boolean surrogateEnabled;
    private Map<String, Set<String>> surrogateRequiredAttributes = new HashMap<String, Set<String>>();

    public boolean doPrincipalAttributesAllowServiceAccess(String principal, Map<String, Object> attributes) {
        if (this.isSurrogateAuthenticationSession(attributes)) {
            if (!this.isSurrogateEnabled()) {
                return false;
            }
            return this.doPrincipalAttributesAllowSurrogateServiceAccess(attributes);
        }
        return super.doPrincipalAttributesAllowServiceAccess(principal, attributes);
    }

    protected boolean doPrincipalAttributesAllowSurrogateServiceAccess(Map<String, Object> principalAttributes) {
        if (!this.enoughRequiredAttributesAvailableToProcess(principalAttributes, this.surrogateRequiredAttributes)) {
            LOGGER.debug("Surrogate access is denied. There are not enough attributes available to satisfy the requirements [{}]", this.surrogateRequiredAttributes);
            return false;
        }
        if (!this.doRequiredAttributesAllowPrincipalAccess(principalAttributes, this.surrogateRequiredAttributes)) {
            LOGGER.debug("Surrogate access is denied. The principal does not have the required attributes [{}] specified by this strategy", this.surrogateRequiredAttributes);
            return false;
        }
        return true;
    }

    @Generated
    public boolean isSurrogateEnabled() {
        return this.surrogateEnabled;
    }

    @Generated
    public Map<String, Set<String>> getSurrogateRequiredAttributes() {
        return this.surrogateRequiredAttributes;
    }

    @Generated
    public void setSurrogateEnabled(boolean surrogateEnabled) {
        this.surrogateEnabled = surrogateEnabled;
    }

    @Generated
    public void setSurrogateRequiredAttributes(Map<String, Set<String>> surrogateRequiredAttributes) {
        this.surrogateRequiredAttributes = surrogateRequiredAttributes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SurrogateRegisteredServiceAccessStrategy)) {
            return false;
        }
        SurrogateRegisteredServiceAccessStrategy other = (SurrogateRegisteredServiceAccessStrategy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.surrogateEnabled != other.surrogateEnabled) {
            return false;
        }
        Map<String, Set<String>> this$surrogateRequiredAttributes = this.surrogateRequiredAttributes;
        Map<String, Set<String>> other$surrogateRequiredAttributes = other.surrogateRequiredAttributes;
        return !(this$surrogateRequiredAttributes == null ? other$surrogateRequiredAttributes != null : !((Object)this$surrogateRequiredAttributes).equals(other$surrogateRequiredAttributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SurrogateRegisteredServiceAccessStrategy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.surrogateEnabled ? 79 : 97);
        Map<String, Set<String>> $surrogateRequiredAttributes = this.surrogateRequiredAttributes;
        result = result * 59 + ($surrogateRequiredAttributes == null ? 43 : ((Object)$surrogateRequiredAttributes).hashCode());
        return result;
    }
}

