/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apidesign.bck2brwsr.core.JavaScriptBody;

public abstract class ClassLoader {
    private final ClassLoader parent;
    private static ClassLoader SYSTEM;

    @JavaScriptBody(args={}, body="")
    private static native void registerNatives();

    protected ClassLoader(ClassLoader parent) {
        this.parent = parent;
    }

    protected ClassLoader() {
        this.parent = null;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.parent != null ? this.parent.loadClass(name, false) : this.findBootstrapClassOrNull(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (c == null) {
                    c = this.findClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    protected Object getClassLoadingLock(String className) {
        ClassLoader lock = this;
        return lock;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] b, int off, int len) throws ClassFormatError {
        throw new SecurityException();
    }

    protected final Class<?> defineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        throw new SecurityException();
    }

    protected final void resolveClass(Class<?> c) {
        this.resolveClass0(c);
    }

    private native void resolveClass0(Class var1);

    protected final Class<?> findLoadedClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    protected final void setSigners(Class<?> c, Object[] signers) {
        throw new UnsupportedOperationException();
    }

    public URL getResource(String name) {
        URL url = this.parent != null ? this.parent.getResource(name) : ClassLoader.getBootstrapResource(name);
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (this == SYSTEM) {
            return this.findResources(name);
        }
        Enumeration[] tmp = new Enumeration[]{this.parent != null ? this.parent.getResources(name) : ClassLoader.getBootstrapResources(name), this.findResources(name)};
        return new CompoundEnumeration(tmp);
    }

    protected URL findResource(String name) {
        return null;
    }

    protected Enumeration<URL> findResources(String name) throws IOException {
        return new CompoundEnumeration(new Enumeration[0]);
    }

    private static native Class<? extends ClassLoader> getCaller(int var0);

    public static URL getSystemResource(String name) {
        ClassLoader system = ClassLoader.getSystemClassLoader();
        if (system == null) {
            return ClassLoader.getBootstrapResource(name);
        }
        return system.getResource(name);
    }

    public static Enumeration<URL> getSystemResources(String name) throws IOException {
        ClassLoader system = null;
        if (system == null) {
            return ClassLoader.getBootstrapResources(name);
        }
        return system.getResources(name);
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String name) {
        URL url = ClassLoader.getSystemResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public final ClassLoader getParent() {
        throw new SecurityException();
    }

    public static ClassLoader getSystemClassLoader() {
        if (SYSTEM == null) {
            SYSTEM = new ClassLoader(){

                @Override
                protected Enumeration<URL> findResources(String name) throws IOException {
                    return ClassLoader.getBootstrapResources(name);
                }

                @Override
                protected URL findResource(String name) {
                    return ClassLoader.getBootstrapResource(name);
                }

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    return Class.forName(name);
                }
            };
        }
        return SYSTEM;
    }

    boolean isAncestor(ClassLoader cl) {
        ClassLoader acl = this;
        do {
            if (cl != (acl = acl.parent)) continue;
            return true;
        } while (acl != null);
        return false;
    }

    private Class findBootstrapClassOrNull(String name) {
        throw new UnsupportedOperationException();
    }

    private static URL getBootstrapResource(String name) {
        return Object.class.getResource("/" + name);
    }

    @JavaScriptBody(args={"name", "skip"}, body="var lb = vm.loadBytes ? vm.loadBytes : exports.loadBytes;return lb ? lb(name, skip) : null;")
    static native byte[] getResourceAsStream0(String var0, int var1);

    private static Enumeration<URL> getBootstrapResources(String name) {
        return new ResEnum(name);
    }

    static {
        ClassLoader.registerNatives();
    }

    private static class CompoundEnumeration
    implements Enumeration<URL> {
        private URL next;
        private int index;
        private final Enumeration[] arr;

        public CompoundEnumeration(Enumeration[] arr) {
            this.arr = arr;
            this.index = 0;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.next == null && this.index < this.arr.length) {
                if (this.arr[this.index].hasMoreElements()) {
                    this.next = (URL)this.arr[this.index].nextElement();
                } else if (this.index < this.arr.length) {
                    ++this.index;
                    return this.hasMoreElements();
                }
            }
            return this.next != null;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            URL r = this.next;
            this.next = null;
            return r;
        }
    }

    private static class OneOrZeroEnum
    implements Enumeration<URL> {
        private URL u;

        public OneOrZeroEnum(URL u) {
            this.u = u;
        }

        @Override
        public boolean hasMoreElements() {
            return this.u != null;
        }

        @Override
        public URL nextElement() {
            URL r = this.u;
            if (r == null) {
                throw new NoSuchElementException();
            }
            this.u = null;
            return r;
        }
    }

    private static class ResEnum
    implements Enumeration<URL> {
        private final String name;
        private URL next;
        private int skip;

        public ResEnum(String name) {
            this.name = name;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.next == null && this.skip >= 0) {
                byte[] arr;
                if ((arr = ClassLoader.getResourceAsStream0(this.name, this.skip++)) != null) {
                    this.next = Class.newResourceURL(this.name, arr);
                } else {
                    this.skip = -1;
                }
            }
            return this.next != null;
        }

        @Override
        public URL nextElement() {
            URL r = this.next;
            if (r == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            return r;
        }
    }
}

