/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Enumeration;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.emul.reflect.AnnotationImpl;
import org.apidesign.bck2brwsr.emul.reflect.MethodImpl;

public final class Method
extends AccessibleObject
implements GenericDeclaration,
Member {
    private final Class<?> clazz;
    private final String name;
    private final Object data;
    private final String sig;

    private String getGenericSignature() {
        return null;
    }

    Method(Class<?> declaringClass, String name, Object data, String sig) {
        this.clazz = declaringClass;
        this.name = name;
        this.data = data;
        this.sig = sig;
    }

    Method copy() {
        return this;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return Method.getAccess(this.data);
    }

    @JavaScriptBody(args={"self"}, body="return self.access;")
    static native int getAccess(Object var0);

    public TypeVariable<Method>[] getTypeParameters() {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnType() {
        return MethodImpl.signatureParser(this.sig).nextElement();
    }

    public Type getGenericReturnType() {
        throw new UnsupportedOperationException();
    }

    public Class<?>[] getParameterTypes() {
        return Method.getParameterTypes(this.sig);
    }

    static Class<?>[] getParameterTypes(String sig) {
        Class[] arr = new Class[MethodImpl.signatureElements(sig) - 1];
        Enumeration<Class> en = MethodImpl.signatureParser(sig);
        en.nextElement();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = en.nextElement();
        }
        return arr;
    }

    public Type[] getGenericParameterTypes() {
        throw new UnsupportedOperationException();
    }

    public Class<?>[] getExceptionTypes() {
        return new Class[0];
    }

    public Type[] getGenericExceptionTypes() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Method) {
            Method other = (Method)obj;
            return this.data == other.data;
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            int mod = this.getModifiers() & Modifier.methodModifiers();
            if (mod != 0) {
                sb.append(Modifier.toString(mod)).append(' ');
            }
            sb.append(Field.getTypeName(this.getReturnType())).append(' ');
            sb.append(Field.getTypeName(this.getDeclaringClass())).append('.');
            sb.append(this.getName()).append('(');
            Class<?>[] params = this.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(Field.getTypeName(params[j]));
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public String toGenericString() {
        try {
            Type genRetType;
            TypeVariable<Method>[] typeparms;
            StringBuilder sb = new StringBuilder();
            int mod = this.getModifiers() & Modifier.methodModifiers();
            if (mod != 0) {
                sb.append(Modifier.toString(mod)).append(' ');
            }
            if ((typeparms = this.getTypeParameters()).length > 0) {
                boolean first = true;
                sb.append('<');
                for (TypeVariable<Method> typeparm : typeparms) {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append(typeparm.toString());
                    first = false;
                }
                sb.append("> ");
            }
            sb.append((genRetType = this.getGenericReturnType()) instanceof Class ? Field.getTypeName((Class)genRetType) : genRetType.toString()).append(' ');
            sb.append(Field.getTypeName(this.getDeclaringClass())).append('.');
            sb.append(this.getName()).append('(');
            Type[] params = this.getGenericParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                String param;
                String string = param = params[j] instanceof Class ? Field.getTypeName((Class)params[j]) : params[j].toString();
                if (this.isVarArgs() && j == params.length - 1) {
                    param = param.replaceFirst("\\[\\]$", "...");
                }
                sb.append(param);
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            Type[] exceptions = this.getGenericExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(exceptions[k] instanceof Class ? ((Class)exceptions[k]).getName() : exceptions[k].toString());
                    if (k >= exceptions.length - 1) continue;
                    sb.append(',');
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public Object invoke(Object obj, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean nonStatic;
        boolean bl = nonStatic = (this.getModifiers() & 8) == 0;
        if (nonStatic && obj == null) {
            throw new NullPointerException();
        }
        Class<?>[] types = this.getParameterTypes();
        if (types.length != args.length) {
            throw new IllegalArgumentException("Types len " + types.length + " args: " + args.length);
        }
        args = (Object[])args.clone();
        for (int i = 0; i < types.length; ++i) {
            Class<?> c = types[i];
            if (!c.isPrimitive() || args[i] == null) continue;
            args[i] = MethodImpl.toPrimitive(args[i]);
        }
        Object res = Method.invokeTry(nonStatic, this, obj, args);
        if (this.getReturnType().isPrimitive()) {
            res = MethodImpl.fromPrimitive(this.getReturnType(), res);
        }
        return res;
    }

    @JavaScriptBody(args={"st", "method", "self", "args"}, body="var p; var cll;\nif (st) {\n  cll = self[method._name() + '__' + method._sig()];\n  p = args;\n} else {\n  p = args;\n  cll = method._data();}\nreturn cll.apply(self, p);\n")
    private static native Object invoke0(boolean var0, Method var1, Object var2, Object[] var3);

    private static Object invokeTry(boolean isStatic, Method m, Object self, Object[] args) throws InvocationTargetException {
        try {
            return Method.invoke0(isStatic, m, self, args);
        }
        catch (Throwable ex) {
            throw new InvocationTargetException(ex, ex.getMessage());
        }
    }

    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    @JavaScriptBody(args={"ac"}, body="var a = this._data().anno;\nif (a) {\n  a = a['L' + ac.jvmName + ';'];\n}\nreturn a ? a : null;")
    private native Object getAnnotationData(Class<?> var1);

    @JavaScriptBody(args={}, body="var a = this._data().anno;\nif (a) {\n  var arr = [];\n  for (p in a) {\n    arr.push(p);\n  }\n  return arr;\n} else return [];\n")
    private native String[] getAnnotationNames();

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Object data = this.getAnnotationData(annotationClass);
        return data == null ? null : (T)AnnotationImpl.create(annotationClass, data);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        String[] arr = this.getAnnotationNames();
        Annotation[] res = new Annotation[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Class<Annotation> annoType;
            String forName = arr[i].substring(1, arr[i].length() - 1).replace('/', '.');
            try {
                annoType = Class.forName(forName).asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(forName);
            }
            res[i] = this.getAnnotation(annoType);
        }
        return res;
    }

    public Object getDefaultValue() {
        throw new UnsupportedOperationException();
    }

    public Annotation[][] getParameterAnnotations() {
        throw new UnsupportedOperationException();
    }

    @JavaScriptBody(args={"primitive", "sig", "fn", "length"}, body="var arr = new Array(length);\nvar value = primitive ? 0 : null;\nfor(var i = 0; i < length; i++) arr[i] = value;\nObject.defineProperty(arr, 'jvmName', { 'configurable': true, 'writable': true, 'value': sig });\nObject.defineProperty(arr, 'fnc', { 'configurable': true, 'writable': true, 'value' : fn });\nreturn arr;")
    static native Object newArray(boolean var0, String var1, Object var2, int var3);

    @JavaScriptBody(args={"arr"}, body="return arr.length;")
    static native int arrayLength(Object var0);

    @JavaScriptBody(args={"cntstr"}, body="return cntstr(false).constructor.$class;")
    static native Class<?> classFromFn(Object var0);

    @JavaScriptBody(args={"array", "index"}, body="return array[index];")
    static native Object atArray(Object var0, int var1);

    @JavaScriptBody(args={"array", "index", "v"}, body="array[index] = v;")
    static native Object setArray(Object var0, int var1, Object var2);

    static {
        MethodImpl.INSTANCE = new MethodImpl(){

            @Override
            protected Method create(Class<?> declaringClass, String name, Object data, String sig) {
                return new Method(declaringClass, name, data, sig);
            }

            @Override
            protected Constructor create(Class<?> declaringClass, Object data, String sig) {
                return new Constructor(declaringClass, data, sig);
            }
        };
    }
}

