/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.Parts;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apidesign.bck2brwsr.core.JavaScriptBody;

public final class URL
implements Serializable {
    static final long serialVersionUID = -7627629688361524110L;
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private String protocol;
    private String host;
    private int port = -1;
    private String file;
    private transient String query;
    private String authority;
    private transient String path;
    private transient String userInfo;
    private String ref;
    transient Object hostAddress;
    transient URLStreamHandler handler;
    private int hashCode = -1;
    private byte[] arr;
    private URL blob;

    public URL(String protocol, String host, int port, String file) throws MalformedURLException {
        this(protocol, host, port, file, null);
    }

    public URL(String protocol, String host, String file) throws MalformedURLException {
        this(protocol, host, -1, file);
    }

    public URL(String protocol, String host, int port, String file, URLStreamHandler handler) throws MalformedURLException {
        if (handler != null) {
            throw new SecurityException();
        }
        this.protocol = protocol = protocol.toLowerCase();
        if (host != null) {
            if (host.indexOf(58) >= 0 && !host.startsWith("[")) {
                host = "[" + host + "]";
            }
            this.host = host;
            if (port < -1) {
                throw new MalformedURLException("Invalid port number :" + port);
            }
            this.port = port;
            this.authority = port == -1 ? host : host + ":" + port;
        }
        Parts parts = new Parts(file);
        this.path = parts.getPath();
        this.query = parts.getQuery();
        this.file = this.query != null ? this.path + "?" + this.query : this.path;
        this.ref = parts.getRef();
        if (handler == null && (handler = URL.getURLStreamHandler(protocol)) == null) {
            throw new MalformedURLException("unknown protocol: " + protocol);
        }
        this.handler = handler;
    }

    public URL(String spec) throws MalformedURLException {
        this(null, spec);
    }

    private URL(String spec, byte[] arr) throws MalformedURLException {
        this(null, spec);
        this.arr = arr;
    }

    public URL(URL context, String spec) throws MalformedURLException {
        this(context, spec, null);
    }

    public URL(URL context, String spec, URLStreamHandler handler) throws MalformedURLException {
        this(URL.findContext(context), spec, handler != null);
    }

    private URL(URL context, String spec, boolean ishandler) throws MalformedURLException {
        if (ishandler) {
            throw new SecurityException();
        }
        URLStreamHandler handler = null;
        String original = spec;
        int start = 0;
        String newProtocol = null;
        boolean aRef = false;
        boolean isRelative = false;
        try {
            char c;
            int i;
            int limit;
            for (limit = spec.length(); limit > 0 && spec.charAt(limit - 1) <= ' '; --limit) {
            }
            while (start < limit && spec.charAt(start) <= ' ') {
                ++start;
            }
            if (spec.regionMatches(true, start, "url:", 0, 4)) {
                start += 4;
            }
            if (start < spec.length() && spec.charAt(start) == '#') {
                aRef = true;
            }
            for (i = start; !aRef && i < limit && (c = spec.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                String s = spec.substring(start, i).toLowerCase();
                if (!this.isValidProtocol(s)) break;
                newProtocol = s;
                start = i + 1;
                break;
            }
            this.protocol = newProtocol;
            if (context != null && (newProtocol == null || newProtocol.equalsIgnoreCase(context.protocol))) {
                if (handler == null) {
                    handler = context.handler;
                }
                if (context.path != null && context.path.startsWith("/")) {
                    newProtocol = null;
                }
                if (newProtocol == null) {
                    this.protocol = context.protocol;
                    this.authority = context.authority;
                    this.userInfo = context.userInfo;
                    this.host = context.host;
                    this.port = context.port;
                    this.file = context.file;
                    this.path = context.path;
                    isRelative = true;
                }
            }
            if (this.protocol == null) {
                throw new MalformedURLException("no protocol: " + original);
            }
            if (handler == null && (handler = URL.getURLStreamHandler(this.protocol)) == null) {
                throw new MalformedURLException("unknown protocol: " + this.protocol);
            }
            this.handler = handler;
            i = spec.indexOf(35, start);
            if (i >= 0) {
                this.ref = spec.substring(i + 1, limit);
                limit = i;
            }
            if (isRelative && start == limit) {
                this.query = context.query;
                if (this.ref == null) {
                    this.ref = context.ref;
                }
            }
            handler.parseURL(this, spec, start, limit);
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (Exception e) {
            MalformedURLException exception = new MalformedURLException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    private boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = protocol.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(String protocol, String host, int port, String file, String ref) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = protocol;
            this.host = host;
            this.authority = port == -1 ? host : host + ":" + port;
            this.port = port;
            this.file = file;
            this.ref = ref;
            this.hashCode = -1;
            this.hostAddress = null;
            int q = file.lastIndexOf(63);
            if (q != -1) {
                this.query = file.substring(q + 1);
                this.path = file.substring(0, q);
            } else {
                this.path = file;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.file = query == null ? path : path + "?" + query;
            this.userInfo = userInfo;
            this.path = path;
            this.ref = ref;
            this.hashCode = -1;
            this.hostAddress = null;
            this.query = query;
            this.authority = authority;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getAuthority() {
        return this.authority;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.handler.getDefaultPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getFile() {
        return this.file;
    }

    public String getRef() {
        return this.ref;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URL)) {
            return false;
        }
        URL u2 = (URL)obj;
        return this.handler.equals(this, u2);
    }

    public synchronized int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        this.hashCode = this.handler.hashCode(this);
        return this.hashCode;
    }

    public boolean sameFile(URL other) {
        return this.handler.sameFile(this, other);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.toString());
    }

    public URLConnection openConnection() throws IOException {
        return this.handler.openConnection(this);
    }

    public final InputStream openStream() throws IOException {
        if (this.arr != null) {
            return new ByteArrayInputStream(this.arr);
        }
        byte[] arr = (byte[])this.getContent(new Class[]{byte[].class});
        if (arr == null) {
            throw new IOException();
        }
        return new ByteArrayInputStream(arr);
    }

    public final Object getContent() throws IOException {
        try {
            return URL.loadText(this.toExternalForm());
        }
        catch (Throwable ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @JavaScriptBody(args={"url"}, body="var request = new XMLHttpRequest();\nrequest.open('GET', url, false);\nrequest.send();\nif (request.status === 0) throw 'Network error';\nreturn request.responseText;\n")
    private static native String loadText(String var0) throws Throwable;

    @JavaScriptBody(args={"url", "arr"}, body="var request = new XMLHttpRequest();\nrequest.open('GET', url, false);\nrequest.overrideMimeType('text\\/plain; charset=x-user-defined');\nrequest.send();\nif (request.status === 0) throw 'Network error';\nvar t = request.responseText;\nfor (var i = 0; i < t.length; i++) arr.push(t.charCodeAt(i) & 0xff);\nreturn arr;\n")
    private static native Object loadBytes(String var0, byte[] var1) throws Throwable;

    public final Object getContent(Class[] classes) throws IOException {
        for (Class c : classes) {
            try {
                if (c == String.class) {
                    return URL.loadText(this.toExternalForm());
                }
                if (c != byte[].class) continue;
                return URL.loadBytes(this.toExternalForm(), new byte[0]);
            }
            catch (Throwable t) {
                throw new IOException(t.getMessage());
            }
        }
        return null;
    }

    @JavaScriptBody(args={"data"}, body="if (typeof Blob !== 'undefined' && typeof Uint8Array !== 'undefined' && typeof URL !== 'undefined' && typeof URL.createObjectURL != 'undefined') {\n  var s = new Uint8Array(data);\n  var b = new Blob([ s ]);\n  return URL.createObjectURL(b);\n} else {\n  return null;\n}")
    static native String toBlobURL(byte[] var0);

    @JavaScriptBody(args={"url"}, body="URL.revokeObjectURL(url);")
    static native void closeBlob(String var0);

    static URLStreamHandler getURLStreamHandler(String protocol) {
        URLStreamHandler universal = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                ByteArrayInputStream is;
                if (u.arr != null) {
                    is = new ByteArrayInputStream(u.arr);
                    if (u.blob != null) {
                        u = u.blob;
                    } else {
                        String blob = URL.toBlobURL(u.arr);
                        if (blob != null) {
                            URL blobURL = new URL(null, blob, false);
                            blobURL.blob = blobURL;
                            URL.access$002(blobURL, u.arr);
                            u = blobURL;
                        }
                    }
                } else {
                    is = null;
                }
                class ResourceConnection
                extends URLConnection
                implements Closeable {
                    private final URL u;
                    Object stream;

                    public ResourceConnection(URL url) {
                        super(url);
                        this.stream = is;
                        this.u = url;
                    }

                    @Override
                    public void connect() throws IOException {
                        if (this.stream == null) {
                            try {
                                byte[] arr = (byte[])this.u.getContent(new Class[]{byte[].class});
                                this.stream = new ByteArrayInputStream(arr);
                            }
                            catch (IOException ex) {
                                this.stream = ex;
                                throw ex;
                            }
                        }
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        this.connect();
                        if (this.stream instanceof IOException) {
                            throw (IOException)this.stream;
                        }
                        return (InputStream)this.stream;
                    }

                    @Override
                    public void close() throws IOException {
                        if (this.u.blob != null) {
                            URL.closeBlob(this.u.blob.toExternalForm());
                        }
                    }

                    @Override
                    public URL getURL() {
                        return this.u;
                    }
                }
                return new ResourceConnection(u);
            }
        };
        return universal;
    }

    private static URL findContext(URL context) throws MalformedURLException {
        String base;
        if (context == null && (base = URL.findBaseURL()) != null) {
            context = new URL(null, base, false);
        }
        return context;
    }

    @JavaScriptBody(args={}, body="var l;\nif (typeof location !== 'object') {  if (typeof window !== 'object') return null;\n  if (!window.location) return null;\n  l = window.location;\n} else {\n  l = location;\n}\nif (!l.href) return null;\nreturn l.href;\n")
    private static native String findBaseURL();

    static /* synthetic */ byte[] access$002(URL x0, byte[] x1) {
        x0.arr = x1;
        return x1;
    }
}

