/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.TaskQueue;
import java.util.TimerTask;
import org.apidesign.bck2brwsr.core.JavaScriptBody;
import org.apidesign.bck2brwsr.emul.lang.System;

class TimerThread
implements Runnable {
    boolean newTasksMayBeScheduled = true;
    private final TaskQueue queue;
    private Object prevTimeout;

    TimerThread(TaskQueue queue) {
        this.queue = queue;
    }

    void notifyQueue(int delay) {
        if (delay < 1) {
            delay = 1;
        }
        this.prevTimeout = TimerThread.setTimeout(delay, this, this.prevTimeout);
    }

    @JavaScriptBody(args={"delay", "r", "prev"}, body="if (prev) {\n  window.clearTimeout(prev);\n}\nreturn window.setTimeout(function() {\n  r.run__V();\n}, delay);\n")
    private static native Object setTimeout(int var0, Runnable var1, Object var2);

    private static void log(String msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mainLoop(1);
        }
        finally {
            TaskQueue taskQueue = this.queue;
            synchronized (taskQueue) {
                if (!this.queue.isEmpty()) {
                    long next = this.queue.getMin().nextExecutionTime;
                    long now = System.currentTimeMillis();
                    int delta = (int)(next - now);
                    this.notifyQueue(delta);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop(int inc) {
        for (int i = 0; i < 1; i += inc) {
            try {
                boolean taskFired;
                TimerTask task;
                TaskQueue taskQueue = this.queue;
                synchronized (taskQueue) {
                    long currentTime;
                    long executionTime;
                    if (!this.queue.isEmpty() || this.newTasksMayBeScheduled) {
                        // empty if block
                    }
                    if (this.queue.isEmpty()) {
                        break;
                    }
                    task = this.queue.getMin();
                    Object object = task.lock;
                    synchronized (object) {
                        if (task.state == 3) {
                            this.queue.removeMin();
                            continue;
                        }
                        executionTime = task.nextExecutionTime;
                        currentTime = System.currentTimeMillis();
                        taskFired = executionTime <= currentTime;
                        if (taskFired) {
                            if (task.period == 0L) {
                                this.queue.removeMin();
                                task.state = 2;
                            } else {
                                this.queue.rescheduleMin(task.period < 0L ? currentTime - task.period : executionTime + task.period);
                            }
                        }
                    }
                    if (!taskFired) {
                        this.notifyQueue((int)(executionTime - currentTime));
                        return;
                    }
                }
                if (!taskFired) continue;
                TimerThread.log("Running " + task);
                task.run();
                TimerThread.log("Done running " + task);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

