/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.spi.model;

import org.arquillian.container.chameleon.FileUtils;
import org.arquillian.container.chameleon.Loader;
import org.arquillian.container.chameleon.spi.model.Container;
import org.jboss.arquillian.container.spi.ConfigurationException;

public class Target {
    private String server;
    private String version;
    private Type type;

    public static Target from(String source) {
        Target target = new Target();
        String[] sections = source.split(":");
        if (sections.length < 2 || sections.length > 3) {
            throw new ConfigurationException("Wrong target format [" + source + "] server:version:type");
        }
        target.server = sections[0].toLowerCase();
        target.version = sections[1];
        if (sections.length > 2) {
            for (Type type : Type.values()) {
                if (!sections[2].toLowerCase().contains(type.name().toLowerCase())) continue;
                target.type = type;
                break;
            }
            if (target.type == null) {
                throw new ConfigurationException("Unknown target type " + sections[2] + ". Supported " + Type.values());
            }
        } else {
            target.type = Type.Default;
        }
        return target;
    }

    public Type getType() {
        return this.type;
    }

    public String getServer() {
        return this.server;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.server + ":" + this.version + ":" + (Object)((Object)this.type);
    }

    public boolean isSupported() throws Exception {
        Container[] containers;
        Loader loader = new Loader();
        for (Container container : containers = loader.loadContainers(FileUtils.loadConfiguration("chameleon/default/containers.yaml", true))) {
            if (container.matches(this) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isVersionSupported() throws Exception {
        Container[] containers;
        Loader loader = new Loader();
        for (Container container : containers = loader.loadContainers(FileUtils.loadConfiguration("chameleon/default/containers.yaml", true))) {
            if (!container.isVersionMatches(this)) continue;
            return true;
        }
        return false;
    }

    public static enum Type {
        Remote,
        Managed,
        Embedded,
        Default;


        public static Type from(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }
    }
}

