/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.arquillian.cube.HealthCheck;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.util.Ping;
import org.arquillian.cube.impl.util.ReflectionUtil;
import org.arquillian.cube.impl.util.Timespan;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.metadata.HasPortBindings;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class HealthCheckBeforeClassObserver {
    @Inject
    Instance<DockerClientExecutor> dockerClientExecutorInstance;
    @Inject
    Instance<CubeRegistry> cubeRegistryInstance;

    public void executeHealthCheck(@Observes BeforeClass beforeClass) {
        TestClass testClass = beforeClass.getTestClass();
        if (ReflectionUtil.isClassWithAnnotation((Class)testClass.getJavaClass(), HealthCheck.class)) {
            HealthCheck healthCheck = (HealthCheck)testClass.getAnnotation(HealthCheck.class);
            this.executeHealthCheck(healthCheck);
        }
    }

    private boolean executeHealthCheck(HealthCheck healthCheck) {
        URL url = this.buildUrl(healthCheck);
        int pollIterations = healthCheck.iterations();
        long sleepTime = Timespan.toMilliseconds((String)healthCheck.interval());
        int responseCode = healthCheck.responseCode();
        String method = healthCheck.method();
        Long connectTimeout = Timespan.toMilliseconds((String)healthCheck.timeout());
        return Ping.ping(pollIterations, sleepTime, TimeUnit.MILLISECONDS, () -> {
            HttpURLConnection urlConnection = null;
            try {
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod(method);
                urlConnection.setConnectTimeout(connectTimeout.intValue());
                urlConnection.setReadTimeout(connectTimeout.intValue());
                urlConnection.connect();
                int connectionResponseCode = urlConnection.getResponseCode();
                if (responseCode != connectionResponseCode) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
            return true;
        });
    }

    private URL buildUrl(HealthCheck healthCheck) {
        String dockerServerIp = ((DockerClientExecutor)this.dockerClientExecutorInstance.get()).getDockerServerIp();
        String schema = healthCheck.schema();
        int port = this.resolvePort(healthCheck.containerName(), healthCheck.port());
        String context = healthCheck.value();
        return this.getUrlToService(schema, dockerServerIp, port, context);
    }

    private URL getUrlToService(String schema, String dockerServerIp, int port, String context) {
        try {
            return new URL(schema, dockerServerIp, port, context);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private int resolvePort(String containerName, int port) {
        if ("".equals(containerName.trim())) {
            return port;
        }
        return this.getBindingPort(containerName, port);
    }

    private int getBindingPort(String cubeId, int exposedPort) {
        HasPortBindings portBindings;
        HasPortBindings.PortAddress mappedAddress;
        int bindPort = -1;
        Cube cube = this.getCube(cubeId);
        if (cube != null && (mappedAddress = (portBindings = (HasPortBindings)cube.getMetadata(HasPortBindings.class)).getMappedAddress(exposedPort)) != null) {
            bindPort = mappedAddress.getPort();
        }
        return bindPort;
    }

    private Cube getCube(String cubeId) {
        return ((CubeRegistry)this.cubeRegistryInstance.get()).getCube(cubeId);
    }
}

