/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.util.concurrent.TimeUnit;
import org.arquillian.cube.Sleep;
import org.arquillian.cube.impl.util.ReflectionUtil;
import org.arquillian.cube.impl.util.Timespan;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class SleepBeforeClassObserver {
    public void executeSleep(@Observes BeforeClass beforeClass) {
        TestClass testClass = beforeClass.getTestClass();
        if (ReflectionUtil.isClassWithAnnotation((Class)testClass.getJavaClass(), Sleep.class)) {
            Sleep sleep = (Sleep)testClass.getAnnotation(Sleep.class);
            this.executeSleep(sleep);
        }
    }

    private void executeSleep(Sleep sleep) {
        long milliseconds = Timespan.toMilliseconds((String)sleep.value());
        try {
            TimeUnit.MILLISECONDS.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

