/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.client.config.ExposedPort;
import org.arquillian.cube.docker.impl.client.config.Image;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.config.Network;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.docker.compose.DockerComposeEnvironmentVarResolver;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public final class ConfigUtil {
    private static final String NETWORKS = "networks";
    private static final String CONTAINERS = "containers";

    private ConfigUtil() {
    }

    public static String[] trim(String[] data) {
        ArrayList<String> result = new ArrayList<String>();
        for (String val : data) {
            String trimmed = val.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result.toArray(new String[0]);
    }

    public static String[] reverse(String[] cubeIds) {
        String[] result = new String[cubeIds.length];
        int n = cubeIds.length - 1;
        for (int i = 0; i < cubeIds.length; ++i) {
            result[n--] = cubeIds[i];
        }
        return result;
    }

    public static String dump(DockerCompositions containers) {
        Yaml yaml = new Yaml((Representer)new CubeRepresenter());
        return yaml.dump((Object)containers);
    }

    public static DockerCompositions load(String content) {
        return ConfigUtil.load(new ByteArrayInputStream(content.getBytes()));
    }

    public static DockerCompositions load(InputStream inputStream) {
        String content = DockerComposeEnvironmentVarResolver.replaceParameters(inputStream);
        Yaml yaml = new Yaml((BaseConstructor)new CubeConstructor());
        Map rawLoad = (Map)yaml.load(content);
        DockerCompositions containers = new DockerCompositions();
        for (Map.Entry rawLoadEntry : rawLoad.entrySet()) {
            if (NETWORKS.equals(rawLoadEntry.getKey())) {
                Map rawNetworks = (Map)rawLoadEntry.getValue();
                for (Map.Entry rawNetworkEntry : rawNetworks.entrySet()) {
                    Network network = (Network)yaml.loadAs(yaml.dump(rawNetworkEntry.getValue()), Network.class);
                    containers.add((String)rawNetworkEntry.getKey(), network);
                }
                continue;
            }
            if (CONTAINERS.equals(rawLoadEntry.getKey())) {
                Map rawContainers = (Map)rawLoadEntry.getValue();
                for (Map.Entry rawContainerEntry : rawContainers.entrySet()) {
                    CubeContainer cubeContainer = (CubeContainer)yaml.loadAs(yaml.dump(rawContainerEntry.getValue()), CubeContainer.class);
                    containers.add((String)rawContainerEntry.getKey(), cubeContainer);
                }
                continue;
            }
            CubeContainer container = (CubeContainer)yaml.loadAs(yaml.dump(rawLoadEntry.getValue()), CubeContainer.class);
            containers.add((String)rawLoadEntry.getKey(), container);
        }
        return ConfigUtil.applyExtendsRules(containers);
    }

    private static DockerCompositions applyExtendsRules(DockerCompositions dockerCompositions) {
        for (Map.Entry<String, CubeContainer> containerEntry : dockerCompositions.getContainers().entrySet()) {
            CubeContainer container = containerEntry.getValue();
            if (container.getExtends() == null) continue;
            String extendsContainer = container.getExtends();
            if (dockerCompositions.get(extendsContainer) == null) {
                throw new IllegalArgumentException(containerEntry.getKey() + " extends a non existing container definition " + extendsContainer);
            }
            CubeContainer extendedContainer = dockerCompositions.get(extendsContainer);
            container.merge(extendedContainer);
        }
        return dockerCompositions;
    }

    public static class CubeConstructor
    extends Constructor {
        public CubeConstructor() {
            this.yamlClassConstructors.put(NodeId.scalar, new CubeMapping());
        }

        private class CubeMapping
        extends Constructor.ConstructScalar {
            private CubeMapping() {
                super((Constructor)CubeConstructor.this);
            }

            public Object construct(Node node) {
                if (node.getType() == PortBinding.class) {
                    String value = CubeConstructor.this.constructScalar((ScalarNode)node).toString();
                    return PortBinding.valueOf(value);
                }
                if (node.getType() == ExposedPort.class) {
                    String value = CubeConstructor.this.constructScalar((ScalarNode)node).toString();
                    return ExposedPort.valueOf(value);
                }
                if (node.getType() == Image.class) {
                    String value = CubeConstructor.this.constructScalar((ScalarNode)node).toString();
                    return Image.valueOf(value);
                }
                if (node.getType() == Link.class) {
                    String value = CubeConstructor.this.constructScalar((ScalarNode)node).toString();
                    return Link.valueOf(value);
                }
                return super.construct(node);
            }
        }
    }

    private static class CubeRepresenter
    extends Representer {
        public CubeRepresenter() {
            this.representers.put(PortBinding.class, new ToStringRepresent());
            this.representers.put(ExposedPort.class, new ToStringRepresent());
            this.representers.put(Image.class, new ToStringRepresent());
            this.representers.put(Link.class, new ToStringRepresent());
            this.addClassTag(DockerCompositions.class, Tag.MAP);
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            if (propertyValue == null) {
                return null;
            }
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }

        public class ToStringRepresent
        implements Represent {
            public Node representData(Object data) {
                return CubeRepresenter.this.representScalar(Tag.STR, data.toString());
            }
        }
    }
}

