/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.smart.testing.surefire.provider;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.arquillian.smart.testing.logger.Log;
import org.arquillian.smart.testing.logger.Logger;

public class LoaderVersionExtractor {
    public static final String ARTIFACT_ID_MAVEN_FAILSAFE_PLUGIN = "maven-failsafe-plugin";
    public static final String ARTIFACT_ID_MAVEN_SUREFIRE_PLUGIN = "maven-surefire-plugin";
    public static final MavenLibrary LIBRARY_SUREFIRE_API = new MavenLibrary("org.apache.maven.surefire", "surefire-api");
    public static final MavenLibrary LIBRARY_FAILSAFE_PLUGIN = new MavenLibrary("org.apache.maven.plugins", "maven-failsafe-plugin");
    public static final MavenLibrary LIBRARY_JUNIT = new MavenLibrary("junit", "junit");
    public static final MavenLibrary LIBRARY_TEST_NG = new MavenLibrary("org.testng", "testng");
    private static final Logger logger = Log.getLogger();
    private static final Map<ClassLoader, Map<MavenLibrary, String>> loaderWithLibraryVersions = new HashMap<ClassLoader, Map<MavenLibrary, String>>();
    private static final List<MavenLibrary> initLibraries = new ArrayList<MavenLibrary>();

    public static String getSurefireApiVersion() {
        return LoaderVersionExtractor.getVersionFromClassLoader(LIBRARY_SUREFIRE_API, Thread.currentThread().getContextClassLoader());
    }

    public static String getFailsafePluginVersion() {
        return LoaderVersionExtractor.getVersionFromClassLoader(LIBRARY_FAILSAFE_PLUGIN, Thread.currentThread().getContextClassLoader());
    }

    public static String getJunitVersion() {
        return LoaderVersionExtractor.getVersionFromClassLoader(LIBRARY_JUNIT, Thread.currentThread().getContextClassLoader());
    }

    public static String getTestNgVersion() {
        return LoaderVersionExtractor.getVersionFromClassLoader(LIBRARY_TEST_NG, Thread.currentThread().getContextClassLoader());
    }

    public static String getVersionFromClassLoader(MavenLibrary mavenLibrary, ClassLoader loader) {
        if (loaderWithLibraryVersions.get(loader) != null) {
            if (!initLibraries.contains(mavenLibrary)) {
                List<MavenLibrary> wrappedLibrary = Collections.singletonList(mavenLibrary);
                Map<MavenLibrary, String> implTitleWithVersion = LoaderVersionExtractor.getTitleWithVersion(wrappedLibrary, loader);
                loaderWithLibraryVersions.put(loader, implTitleWithVersion);
            }
        } else {
            Map<MavenLibrary, String> implTitleWithVersion = LoaderVersionExtractor.getTitleWithVersion(initLibraries, loader);
            loaderWithLibraryVersions.put(loader, implTitleWithVersion);
        }
        return loaderWithLibraryVersions.get(loader).get(mavenLibrary);
    }

    private static Map<MavenLibrary, String> getTitleWithVersion(List<MavenLibrary> libraries, ClassLoader classLoader) {
        HashMap<MavenLibrary, String> implTitleWithVersion = new HashMap<MavenLibrary, String>();
        ArrayList<MavenLibrary> librariesToFind = new ArrayList<MavenLibrary>(libraries);
        try {
            Enumeration<URL> manifests = classLoader.getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                String manifestURL = manifests.nextElement().toString();
                Optional<MavenLibrary> matched = librariesToFind.parallelStream().filter(library -> manifestURL.matches(library.getRegex())).findFirst();
                matched.ifPresent(mavenLibrary -> {
                    MavenLibrary matchedLibrary = mavenLibrary;
                    String startWithVersion = manifestURL.replaceAll(matchedLibrary.getLeadingRegex(), "");
                    String version = startWithVersion.substring(0, startWithVersion.indexOf(File.separator));
                    implTitleWithVersion.put(matchedLibrary, version);
                    librariesToFind.remove(matchedLibrary);
                });
            }
        }
        catch (Exception e) {
            logger.warn("Exception {0} occurred while resolving manifest files", new Object[]{e.getMessage()});
        }
        return implTitleWithVersion;
    }

    static {
        initLibraries.add(LIBRARY_SUREFIRE_API);
        initLibraries.add(LIBRARY_JUNIT);
        initLibraries.add(LIBRARY_TEST_NG);
        initLibraries.add(LIBRARY_FAILSAFE_PLUGIN);
    }

    static class MavenLibrary {
        private final String groupId;
        private final String artifactId;

        MavenLibrary(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        String getRegex() {
            return Pattern.compile(this.getLeadingString() + ".*" + File.separator + this.artifactId + "-.*\\.jar.*").pattern();
        }

        String getLeadingRegex() {
            return Pattern.compile(this.getLeadingString()).pattern();
        }

        private String getLeadingString() {
            return ".*" + File.separator + this.groupId.replaceAll("\\.", File.separator) + File.separator + this.artifactId + File.separator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenLibrary that = (MavenLibrary)o;
            if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
                return false;
            }
            return this.artifactId != null ? this.artifactId.equals(that.artifactId) : that.artifactId == null;
        }

        public int hashCode() {
            int result = this.groupId != null ? this.groupId.hashCode() : 0;
            result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
            return result;
        }
    }
}

