/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.smart.testing.surefire.provider;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;

class SecurityUtils {
    SecurityUtils() {
    }

    static <T> T newInstance(Class<T> implClass, Class<?>[] argumentTypes, Object[] arguments) {
        T obj;
        if (implClass == null) {
            throw new IllegalArgumentException("ImplClass must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            Constructor constructor = SecurityUtils.getConstructor(implClass, argumentTypes);
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(() -> {
                    constructor.setAccessible(true);
                    return null;
                });
            }
            obj = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + implClass, e);
        }
        return obj;
    }

    private static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return AccessController.doPrivileged(() -> clazz.getDeclaredConstructor(argumentTypes));
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }
}

