/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.smart.testing.surefire.provider;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.surefire.cli.CommandLineOption;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.TestsToRun;
import org.arquillian.smart.testing.api.SmartTesting;
import org.arquillian.smart.testing.configuration.Configuration;
import org.arquillian.smart.testing.configuration.ConfigurationLoader;
import org.arquillian.smart.testing.logger.DefaultLoggerFactory;
import org.arquillian.smart.testing.logger.Log;
import org.arquillian.smart.testing.logger.LoggerFactory;
import org.arquillian.smart.testing.surefire.provider.ProviderParametersParser;
import org.arquillian.smart.testing.surefire.provider.SurefireProviderFactory;
import org.arquillian.smart.testing.surefire.provider.logger.SurefireProviderLoggerFactory;

public class SmartTestingSurefireProvider
implements SurefireProvider {
    private final ProviderParametersParser paramParser;
    private final SurefireProviderFactory surefireProviderFactory;
    private final ProviderParameters bootParams;
    private final Configuration configuration;
    private SurefireProvider surefireProvider;

    public SmartTestingSurefireProvider(ProviderParameters bootParams) {
        this.bootParams = bootParams;
        this.paramParser = new ProviderParametersParser(this.bootParams);
        File projectDir = this.getProjectDir();
        this.surefireProviderFactory = new SurefireProviderFactory(this.paramParser, projectDir);
        this.surefireProvider = this.surefireProviderFactory.createInstance();
        this.configuration = ConfigurationLoader.loadPrecalculated((File)projectDir);
        Log.setLoggerFactory((LoggerFactory)new SurefireProviderLoggerFactory(this.getConsoleLogger(), this.isAnyDebugEnabled()));
    }

    SmartTestingSurefireProvider(ProviderParameters bootParams, SurefireProviderFactory surefireProviderFactory) {
        this.bootParams = bootParams;
        this.paramParser = new ProviderParametersParser(this.bootParams);
        this.surefireProviderFactory = surefireProviderFactory;
        this.surefireProvider = surefireProviderFactory.createInstance();
        this.configuration = ConfigurationLoader.loadPrecalculated((File)this.getProjectDir());
        Log.setLoggerFactory((LoggerFactory)new SurefireProviderLoggerFactory(this.getConsoleLogger(), this.isAnyDebugEnabled()));
    }

    public Iterable<Class<?>> getSuites() {
        return this.getOptimizedTestsToRun((TestsToRun)this.surefireProvider.getSuites());
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException, InvocationTargetException {
        TestsToRun orderedTests = this.getTestsToRun(forkTestSet);
        this.surefireProvider = this.surefireProviderFactory.createInstance();
        return this.surefireProvider.invoke((Object)orderedTests);
    }

    public void cancel() {
        this.surefireProvider.cancel();
    }

    private TestsToRun getTestsToRun(Object forkTestSet) throws TestSetFailedException {
        if (forkTestSet instanceof TestsToRun) {
            return (TestsToRun)forkTestSet;
        }
        if (forkTestSet instanceof Class) {
            return TestsToRun.fromClass((Class)((Class)forkTestSet));
        }
        return (TestsToRun)this.getSuites();
    }

    private TestsToRun getOptimizedTestsToRun(TestsToRun testsToRun) {
        Set selection = SmartTesting.with(className -> testsToRun.getClassByName(className) != null, (Configuration)this.configuration).in(this.getProjectDir()).applyOnClasses((Iterable)testsToRun);
        return new TestsToRun(SmartTesting.getClasses((Set)selection));
    }

    private File getProjectDir() {
        if (System.getProperty("basedir") == null) {
            File testSourceDirectory = this.bootParams.getTestRequest().getTestSourceDirectory();
            return this.findFirstMatchingPom(testSourceDirectory);
        }
        return new File(System.getProperty("basedir"));
    }

    private File findFirstMatchingPom(File source) {
        if (source.isDirectory() && new File(source, "pom.xml").exists()) {
            return source;
        }
        return this.findFirstMatchingPom(source.getParentFile());
    }

    private boolean isAnyDebugEnabled() {
        return this.bootParams.getMainCliOptions().contains(CommandLineOption.LOGGING_LEVEL_DEBUG) || this.configuration.isDebug();
    }

    private Object getConsoleLogger() {
        try {
            Optional<Method> method = Arrays.stream(this.bootParams.getClass().getMethods()).filter(this::isGetConsoleLoggerMethod).findFirst();
            if (method.isPresent()) {
                return method.get().invoke((Object)this.bootParams, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            new DefaultLoggerFactory().getLogger().warn("The Surefire version that you are using is not fully compatible with the current version of Smart Testing. Please create an issue.", new Object[0]);
        }
        return null;
    }

    private boolean isGetConsoleLoggerMethod(Method method) {
        return method.getName().equals("getConsoleLogger") && method.getParameterCount() == 0 && method.getModifiers() == 1 && method.getReturnType() != Void.class;
    }
}

