/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.smart.testing.surefire.provider;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.arquillian.smart.testing.surefire.provider.info.ProviderInfo;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;

public class SurefireDependencyResolver {
    public static boolean isWithinVersionSpec(ArtifactVersion artifactVersion, String versionSpec) {
        if (artifactVersion == null) {
            return false;
        }
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)versionSpec);
            return range.containsVersion(artifactVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException("Bug in plugin. Please report with stacktrace");
        }
    }

    public static File[] resolve(ProviderInfo providerInfo) {
        return ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(providerInfo.getDepCoordinates())).withTransitivity()).asFile();
    }

    public static ClassLoader addProviderToClasspath(ProviderInfo providerInfo) {
        if (providerInfo != null) {
            File[] files = SurefireDependencyResolver.resolve(providerInfo);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                return new URLClassLoader(SurefireDependencyResolver.toURLs(files), classLoader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URL[] toURLs(File[] archives) throws Exception {
        URL[] urls = new URL[archives.length];
        for (int i = 0; i < archives.length; ++i) {
            urls[i] = archives[i].toURI().toURL();
        }
        return urls;
    }
}

