/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.smart.testing.surefire.provider;

import java.io.File;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.arquillian.smart.testing.surefire.provider.ProviderParametersParser;
import org.arquillian.smart.testing.surefire.provider.SecurityUtils;
import org.arquillian.smart.testing.surefire.provider.SurefireDependencyResolver;
import org.arquillian.smart.testing.surefire.provider.info.JUnit4ProviderInfo;
import org.arquillian.smart.testing.surefire.provider.info.JUnit5ProviderInfo;
import org.arquillian.smart.testing.surefire.provider.info.JUnitCoreProviderInfo;
import org.arquillian.smart.testing.surefire.provider.info.ProviderInfo;
import org.arquillian.smart.testing.surefire.provider.info.TestNgProviderInfo;

public class SurefireProviderFactory {
    private final ProviderInfo providerInfo;
    private final ProviderParameters providerParameters;
    private final Class<SurefireProvider> surefireProviderClass;

    SurefireProviderFactory(ProviderParametersParser paramParser, File projectDir) {
        ProviderInfo[] wellKnownProviders = new ProviderInfo[]{new TestNgProviderInfo(), new JUnit5ProviderInfo(projectDir), new JUnitCoreProviderInfo(paramParser), new JUnit4ProviderInfo()};
        this.providerInfo = this.autoDetectOneProvider(wellKnownProviders);
        this.providerParameters = paramParser.getProviderParameters();
        this.surefireProviderClass = this.loadProviderClass();
    }

    public SurefireProvider createInstance() {
        return SecurityUtils.newInstance(this.surefireProviderClass, new Class[]{ProviderParameters.class}, new Object[]{this.providerInfo.convertProviderParameters(this.providerParameters)});
    }

    private Class<SurefireProvider> loadProviderClass() {
        try {
            ClassLoader classLoader = SurefireDependencyResolver.addProviderToClasspath(this.providerInfo);
            if (classLoader != null) {
                return classLoader.loadClass(this.providerInfo.getProviderClassName());
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private ProviderInfo autoDetectOneProvider(ProviderInfo[] wellKnownProviders) {
        for (ProviderInfo wellKnownProvider : wellKnownProviders) {
            if (!wellKnownProvider.isApplicable()) continue;
            return wellKnownProvider;
        }
        return null;
    }
}

