/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.smart.testing.surefire.provider.info;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.arquillian.smart.testing.hub.storage.local.LocalStorage;
import org.arquillian.smart.testing.hub.storage.local.TemporaryInternalFiles;
import org.arquillian.smart.testing.surefire.provider.LoaderVersionExtractor;
import org.arquillian.smart.testing.surefire.provider.info.ProviderInfo;

public class JUnit5ProviderInfo
implements ProviderInfo {
    private String junit5SurefirePlatformVersion;

    public JUnit5ProviderInfo(File projectDir) {
        this.junit5SurefirePlatformVersion = this.retrieveJunit5SurefirePlatformVersion(projectDir, LoaderVersionExtractor.getFailsafePluginVersion());
    }

    @Override
    public String getProviderClassName() {
        return "org.junit.platform.surefire.provider.JUnitPlatformProvider";
    }

    @Override
    public boolean isApplicable() {
        return this.junit5SurefirePlatformVersion != null;
    }

    @Override
    public String getDepCoordinates() {
        return "org.junit.platform:junit-platform-surefire-provider:" + this.junit5SurefirePlatformVersion;
    }

    @Override
    public ProviderParameters convertProviderParameters(ProviderParameters providerParameters) {
        return providerParameters;
    }

    String retrieveJunit5SurefirePlatformVersion(File projectDir, String failsafePluginVersion) {
        boolean isFailsafePlugin = failsafePluginVersion != null;
        String prefix = isFailsafePlugin ? "maven-failsafe-plugin" : "maven-surefire-plugin";
        Path junit5PlatformVersionFile = new LocalStorage(projectDir).duringExecution().temporary().file(TemporaryInternalFiles.getJunit5PlatformVersionFileName((String)prefix)).getPath();
        if (Files.exists(junit5PlatformVersionFile, new LinkOption[0])) {
            try {
                byte[] content = Files.readAllBytes(junit5PlatformVersionFile);
                return new String(content);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }
}

