/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.smart.testing.surefire.provider.info;

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.arquillian.smart.testing.surefire.provider.LoaderVersionExtractor;
import org.arquillian.smart.testing.surefire.provider.ProviderParametersParser;
import org.arquillian.smart.testing.surefire.provider.SurefireDependencyResolver;
import org.arquillian.smart.testing.surefire.provider.Validate;
import org.arquillian.smart.testing.surefire.provider.info.JUnitProviderInfo;

public class JUnitCoreProviderInfo
extends JUnitProviderInfo {
    private final ProviderParametersParser paramParser;

    public JUnitCoreProviderInfo(ProviderParametersParser paramParser) {
        super(LoaderVersionExtractor.getJunitVersion());
        this.paramParser = paramParser;
    }

    @Override
    public String getProviderClassName() {
        return "org.apache.maven.surefire.junitcore.JUnitCoreProvider";
    }

    private boolean is47CompatibleJunitDep() {
        return this.getJunitDepVersion() != null && this.isJunit47Compatible(this.getJunitDepVersion());
    }

    @Override
    public boolean isApplicable() {
        ArtifactVersion junitDepVersion = this.getJunitDepVersion();
        if (junitDepVersion == null) {
            return false;
        }
        boolean isJunitArtifact47 = this.isAnyJunit4() && this.isJunit47Compatible(junitDepVersion);
        boolean isAny47ProvidersForcers = this.isAnyConcurrencySelected() || this.isAnyGroupsSelected();
        return isAny47ProvidersForcers && (isJunitArtifact47 || this.is47CompatibleJunitDep()) && LoaderVersionExtractor.getSurefireApiVersion() != null;
    }

    @Override
    public String getDepCoordinates() {
        return "org.apache.maven.surefire:surefire-junit47:" + LoaderVersionExtractor.getSurefireApiVersion();
    }

    private boolean isJunit47Compatible(ArtifactVersion artifactVersion) {
        return SurefireDependencyResolver.isWithinVersionSpec(artifactVersion, "[4.7,)");
    }

    protected boolean isAnyConcurrencySelected() {
        String parallel = this.paramParser.getProperty("parallel");
        return parallel != null && parallel.trim().length() > 0 && !parallel.equals("none");
    }

    protected boolean isAnyGroupsSelected() {
        String groups = this.paramParser.getProperty("groups");
        String excludeGroups = this.paramParser.getProperty("excludegroups");
        return Validate.isNotEmpty(groups) || Validate.isNotEmpty(excludeGroups);
    }
}

