/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.smart.testing.surefire.provider.logger;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.arquillian.smart.testing.logger.DefaultLoggerFactory;
import org.arquillian.smart.testing.logger.Logger;
import org.arquillian.smart.testing.logger.LoggerFactory;

public class SurefireProviderLoggerFactory
implements LoggerFactory {
    private Object logger;
    private boolean debugLogEnabled;
    public static final String NOT_COMPATIBLE_MESSAGE = "The Surefire version that you are using is not fully compatible with the current version of Smart Testing. Please create an issue.";

    public SurefireProviderLoggerFactory(Object consoleLogger, boolean debugLogEnabled) {
        this.logger = consoleLogger;
        this.debugLogEnabled = debugLogEnabled;
    }

    public Logger getLogger() {
        return new SurefireProviderLogger(this.logger);
    }

    private class SurefireProviderLogger
    implements Logger {
        private static final String PREFIX = "%s: Smart Testing Extension - ";
        private Object consoleLogger;
        private Method logMethod;

        private SurefireProviderLogger(Object consoleLogger) {
            this.consoleLogger = consoleLogger;
            this.logMethod = this.getLogMethod();
        }

        public void info(String msg, Object ... args) {
            this.logMessage(this.getFormattedMsg("INFO", msg, args));
        }

        public void warn(String msg, Object ... args) {
            this.logMessage(this.getFormattedMsg("WARN", msg, args));
        }

        public void debug(String msg, Object ... args) {
            if (SurefireProviderLoggerFactory.this.debugLogEnabled) {
                this.logMessage(this.getFormattedMsg("DEBUG", msg, args));
            }
        }

        public void error(String msg, Object ... args) {
            this.logMessage(this.getFormattedMsg("ERROR", msg, args));
        }

        private void logMessage(String message) {
            if (this.logMethod != null) {
                try {
                    this.logMethod.invoke(this.consoleLogger, message);
                    return;
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            System.out.println(message);
        }

        private Method getLogMethod() {
            if (this.consoleLogger != null) {
                Optional<Method> method = Arrays.stream(this.consoleLogger.getClass().getMethods()).filter(this::isPublicConsoleLogMethod).findFirst();
                if (method.isPresent()) {
                    return method.get();
                }
                new DefaultLoggerFactory().getLogger().warn(SurefireProviderLoggerFactory.NOT_COMPATIBLE_MESSAGE, new Object[0]);
            }
            return null;
        }

        private boolean isPublicConsoleLogMethod(Method method) {
            return method.getParameterCount() == 1 && method.getParameterTypes()[0] == String.class && method.getModifiers() == 1;
        }

        private String getFormattedMsg(String level, String msg, Object ... args) {
            if (args != null && args.length > 0) {
                msg = String.format(msg, args);
            }
            StringBuffer formattedMsg = new StringBuffer(String.format(PREFIX, level)).append(msg);
            if (this.consoleLogger != null && this.consoleLogger.getClass().getName().equals("org.apache.maven.surefire.booter.ForkingRunListener")) {
                return formattedMsg.append(System.lineSeparator()).toString();
            }
            return formattedMsg.toString();
        }

        public boolean isDebug() {
            return SurefireProviderLoggerFactory.this.debugLogEnabled;
        }
    }
}

