/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoc.maven;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.asciidoc.maven.AsciidoctorMojo;
import org.asciidoc.maven.io.Zips;

@Mojo(name="zip")
public class AsciidoctorZipMojo
extends AsciidoctorMojo {
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="attach", defaultValue="true")
    protected boolean attach;
    @Parameter(property="zip", defaultValue="true")
    protected boolean zip;
    @Parameter(property="zipDestination", defaultValue="${project.build.directory}/${project.build.finalName}.zip")
    protected File zipDestination;
    @Parameter(property="zipClassifier", defaultValue="asciidoctor")
    protected String zipClassifier;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.zip) {
            try {
                Zips.zip(this.outputDirectory, this.zipDestination);
                this.getLog().info((CharSequence)("Created " + this.zipDestination.getAbsolutePath() + "."));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Can't zip " + this.outputDirectory.getAbsolutePath()), (Throwable)e);
            }
            if (this.attach) {
                if (this.zipClassifier != null) {
                    this.projectHelper.attachArtifact(this.project, "zip", this.zipClassifier, this.zipDestination);
                    this.getLog().info((CharSequence)("Attached " + this.zipDestination.getAbsolutePath() + " with classifier " + this.zipClassifier + "."));
                } else {
                    this.projectHelper.attachArtifact(this.project, "zip", this.zipDestination);
                    this.getLog().info((CharSequence)("Attached " + this.zipDestination.getAbsolutePath() + "."));
                }
            }
        }
    }

    public String getZipClassifier() {
        return this.zipClassifier;
    }

    public void setZipClassifier(String zipClassifier) {
        this.zipClassifier = zipClassifier;
    }

    public File getZipDestination() {
        return this.zipDestination;
    }

    public void setZipDestination(File zipDestination) {
        this.zipDestination = zipDestination;
    }

    public boolean isZip() {
        return this.zip;
    }

    public void setZip(boolean zip) {
        this.zip = zip;
    }

    public boolean isAttach() {
        return this.attach;
    }

    public void setAttach(boolean attach) {
        this.attach = attach;
    }
}

