/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoc.maven.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class AsciidoctorHandler
extends ChannelInboundMessageHandlerAdapter<FullHttpRequest> {
    private static final String HTML_MEDIA_TYPE = "text/html";
    public static final String HTML_EXTENSION = ".html";
    private final File directory;
    private final String defaultPage;

    public AsciidoctorHandler(File workDir, String defaultPage) {
        this.directory = workDir;
        this.defaultPage = defaultPage.contains(".") ? defaultPage : AsciidoctorHandler.addDefaultExtension(defaultPage);
    }

    public void messageReceived(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        HttpResponseStatus status;
        String mediaType;
        ByteBuf body;
        if (msg.getMethod() != HttpMethod.GET) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED, Unpooled.copiedBuffer((CharSequence)"<html><body>Only GET method allowed</body></html>", (Charset)CharsetUtil.UTF_8));
            response.headers().set("Content-Type", (Object)HTML_MEDIA_TYPE);
            this.send(ctx, response);
            return;
        }
        File file = this.deduceFile(msg.getUri());
        if (file.exists()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileInputStream fileInputStream = new FileInputStream(file);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)baos);
            body = Unpooled.copiedBuffer((byte[])baos.toByteArray());
            IOUtils.closeQuietly((InputStream)fileInputStream);
            mediaType = AsciidoctorHandler.mediaType(file.getName());
            status = HttpResponseStatus.OK;
        } else {
            body = Unpooled.copiedBuffer((CharSequence)("<body><html>File not found: " + file.getPath() + "<body></html>"), (Charset)CharsetUtil.UTF_8);
            status = HttpResponseStatus.NOT_FOUND;
            mediaType = HTML_MEDIA_TYPE;
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, body);
        response.headers().set("Content-Type", (Object)mediaType);
        this.send(ctx, response);
    }

    private void send(ChannelHandlerContext ctx, DefaultFullHttpResponse response) {
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private File deduceFile(String path) {
        if (path.isEmpty() || "/".equals(path)) {
            return new File(this.directory, this.defaultPage);
        }
        if (!path.contains(".")) {
            return new File(this.directory, AsciidoctorHandler.addDefaultExtension(path));
        }
        return new File(this.directory, path);
    }

    private static String addDefaultExtension(String path) {
        return path + HTML_EXTENSION;
    }

    private static String mediaType(String name) {
        if (name.endsWith(".js")) {
            return "text/javascript";
        }
        if (name.endsWith(".css")) {
            return "text/css";
        }
        if (name.endsWith(".png")) {
            return "image/png";
        }
        if (name.endsWith(".gif")) {
            return "image/gif";
        }
        if (name.endsWith(".jpeg") || name.endsWith(".jpg")) {
            return "image/jpeg";
        }
        return HTML_MEDIA_TYPE;
    }
}

