/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.site;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.maven.process.AsciidoctorHelper;
import org.asciidoctor.maven.site.SiteConversionConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class SiteConversionConfigurationParser {
    private final MavenProject project;

    SiteConversionConfigurationParser(MavenProject project) {
        this.project = project;
    }

    SiteConversionConfiguration processAsciiDocConfig(Xpp3Dom siteConfig, OptionsBuilder presetOptions, AttributesBuilder presetAttributes) {
        if (siteConfig == null) {
            OptionsBuilder options = presetOptions.attributes(presetAttributes);
            return new SiteConversionConfiguration(options.get(), Collections.emptyList());
        }
        Xpp3Dom asciidocConfig = siteConfig.getChild("asciidoc");
        if (asciidocConfig == null) {
            OptionsBuilder options = presetOptions.attributes(presetAttributes);
            return new SiteConversionConfiguration(options.get(), Collections.emptyList());
        }
        AsciidoctorHelper.addMavenProperties(this.project, presetAttributes);
        ArrayList<String> gemsToRequire = new ArrayList<String>();
        for (Xpp3Dom asciidocOpt : asciidocConfig.getChildren()) {
            String optName = asciidocOpt.getName();
            if ("requires".equals(optName)) {
                Xpp3Dom[] requires = asciidocOpt.getChildren("require");
                if (requires.length <= 0) continue;
                Xpp3Dom[] xpp3DomArray = requires;
                int n = xpp3DomArray.length;
                for (int i = 0; i < n; ++i) {
                    Xpp3Dom requireNode = xpp3DomArray[i];
                    if (requireNode.getValue().contains(",")) {
                        Stream.of(requireNode.getValue().split(",")).map(String::trim).filter(this::isNotBlank).forEach(value -> gemsToRequire.add((String)value));
                        continue;
                    }
                    String value2 = requireNode.getValue();
                    if (value2.trim().length() <= 0) continue;
                    gemsToRequire.add(value2.trim());
                }
                continue;
            }
            if ("attributes".equals(optName)) {
                for (Xpp3Dom asciidocAttr : asciidocOpt.getChildren()) {
                    AsciidoctorHelper.addAttribute(asciidocAttr.getName(), asciidocAttr.getValue(), presetAttributes);
                }
                continue;
            }
            if ("templateDirs".equals(optName) || "template_dirs".equals(optName)) {
                List<File> dirs = Arrays.stream(asciidocOpt.getChildren("dir")).filter(node -> this.isNotBlank(node.getValue())).map(node -> this.resolveProjectDir(this.project, node.getValue())).collect(Collectors.toList());
                presetOptions.templateDirs(dirs.toArray(new File[dirs.size()]));
                continue;
            }
            if ("baseDir".equals(optName)) {
                presetOptions.baseDir(this.resolveProjectDir(this.project, asciidocOpt.getValue()));
                continue;
            }
            presetOptions.option(optName.replaceAll("(?<!_)([A-Z])", "_$1").toLowerCase(), (Object)asciidocOpt.getValue());
        }
        return new SiteConversionConfiguration(presetOptions.attributes(presetAttributes).get(), gemsToRequire);
    }

    public boolean isNotBlank(String value) {
        return value != null && !value.isEmpty() && value.chars().anyMatch(c -> !Character.isWhitespace(c));
    }

    private File resolveProjectDir(MavenProject project, String path) {
        File filePath = new File(path);
        if (!filePath.isAbsolute()) {
            filePath = new File(project.getBasedir(), filePath.toString());
        }
        return filePath;
    }
}

