/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.jruby.AsciidoctorJRuby;
import org.asciidoctor.jruby.internal.JRubyRuntimeContext;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.maven.commons.AsciidoctorHelper;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.extensions.AsciidoctorJExtensionRegistry;
import org.asciidoctor.maven.extensions.ExtensionConfiguration;
import org.asciidoctor.maven.log.LogHandler;
import org.asciidoctor.maven.log.LogRecordFormatter;
import org.asciidoctor.maven.log.LogRecordsProcessors;
import org.asciidoctor.maven.log.MemoryLogHandler;
import org.asciidoctor.maven.model.Resource;
import org.asciidoctor.maven.process.CopyResourcesProcessor;
import org.asciidoctor.maven.process.ResourcesProcessor;
import org.asciidoctor.maven.process.SourceDirectoryFinder;
import org.asciidoctor.maven.process.SourceDocumentFinder;
import org.jruby.Ruby;

@Mojo(name="process-asciidoc", threadSafe=true)
public class AsciidoctorMojo
extends AbstractMojo {
    @Parameter(property="asciidoctor.sourceDirectory", defaultValue="${basedir}/src/docs/asciidoc")
    protected File sourceDirectory;
    @Parameter(property="asciidoctor.outputDirectory", defaultValue="${project.build.directory}/generated-docs")
    protected File outputDirectory;
    @Parameter(property="asciidoctor.outputFile")
    protected File outputFile;
    @Parameter(property="asciidoctor.preserveDirectories", defaultValue="false")
    protected boolean preserveDirectories;
    @Parameter(property="asciidoctor.relativeBaseDir", defaultValue="false")
    protected boolean relativeBaseDir;
    @Parameter(property="asciidoctor.projectDirectory", defaultValue="${basedir}")
    protected File projectDirectory;
    @Parameter(property="asciidoctor.rootDir", defaultValue="${basedir}")
    protected File rootDir;
    @Parameter(property="asciidoctor.baseDir")
    protected File baseDir;
    @Parameter(property="asciidoctor.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="asciidoctor.gemPath")
    protected String gemPath;
    @Parameter(property="asciidoctor.requires")
    protected List<String> requires = new ArrayList<String>();
    @Parameter
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    @Parameter(property="asciidoctor.attributes")
    protected String attributesChain;
    @Parameter(property="asciidoctor.backend", defaultValue="html5")
    protected String backend;
    @Parameter(property="asciidoctor.doctype")
    protected String doctype;
    @Parameter(property="asciidoctor.eruby")
    protected String eruby;
    @Parameter(property="asciidoctor.standalone", defaultValue="true")
    protected boolean standalone;
    @Parameter(property="asciidoctor.templateDirs")
    protected List<File> templateDirs = new ArrayList<File>();
    @Parameter(property="asciidoctor.templateEngine")
    protected String templateEngine;
    @Parameter(property="asciidoctor.templateCache", defaultValue="true")
    protected boolean templateCache;
    @Parameter(property="asciidoctor.sourceDocumentName")
    protected String sourceDocumentName;
    @Parameter(property="asciidoctor.sourceDocumentExtensions")
    protected List<String> sourceDocumentExtensions = new ArrayList<String>();
    @Parameter(property="asciidoctor.sourcemap", defaultValue="false")
    protected boolean sourcemap;
    @Parameter(property="asciidoctor.catalogAssets", defaultValue="false")
    protected boolean catalogAssets;
    @Parameter
    protected List<ExtensionConfiguration> extensions = new ArrayList<ExtensionConfiguration>();
    @Parameter(property="asciidoctor.embedAssets", defaultValue="false")
    protected boolean embedAssets;
    @Parameter
    protected List<Resource> resources;
    @Parameter(property="asciidoctor.verbose", defaultValue="false")
    protected boolean enableVerbose;
    @Parameter
    private LogHandler logHandler = new LogHandler();
    @Inject
    protected MavenProject project;
    protected final ResourcesProcessor defaultResourcesProcessor = new CopyResourcesProcessor();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.processAllSources(this.defaultResourcesProcessor);
    }

    public void processAllSources(ResourcesProcessor resourcesProcessor) throws MojoExecutionException {
        this.processSources(null, resourcesProcessor);
    }

    public void processSources(List<File> sourceFiles, ResourcesProcessor resourcesProcessor) throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"AsciiDoc processing is skipped.");
            return;
        }
        if (this.sourceDirectory == null) {
            throw new MojoExecutionException("Required parameter 'asciidoctor.sourceDirectory' not set.");
        }
        Optional<File> sourceDirectoryCandidate = this.findSourceDirectory(this.sourceDirectory, this.project.getBasedir());
        if (!sourceDirectoryCandidate.isPresent()) {
            this.getLog().info((CharSequence)"No sourceDirectory found. Skipping processing");
            return;
        }
        if (sourceFiles == null) {
            sourceFiles = this.findSourceFiles(sourceDirectoryCandidate.get());
        }
        if (sourceFiles.isEmpty()) {
            this.getLog().info((CharSequence)"No sources found. Skipping processing");
            return;
        }
        if (!this.ensureOutputExists()) {
            this.getLog().error((CharSequence)("Can't create " + this.outputDirectory.getPath()));
            return;
        }
        if (this.resources != null) {
            for (Resource resource : this.resources) {
                if (resource.getDirectory() != null && !resource.getDirectory().isEmpty()) continue;
                throw new MojoExecutionException("Found empty resource directory");
            }
        }
        Asciidoctor asciidoctor = this.getAsciidoctorInstance(this.gemPath);
        if (this.enableVerbose) {
            asciidoctor.requireLibrary(new String[]{"enable_verbose.rb"});
        }
        asciidoctor.requireLibraries(this.requires);
        AsciidoctorJExtensionRegistry extensionRegistry = new AsciidoctorJExtensionRegistry(asciidoctor);
        for (ExtensionConfiguration extension : this.extensions) {
            try {
                extensionRegistry.register(extension.getClassName(), extension.getBlockName());
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        AttributesBuilder attributesBuilder = this.createAttributesBuilder(this, this.project);
        OptionsBuilder optionsBuilder = this.createOptionsBuilder(this, attributesBuilder);
        File sourceDir = sourceDirectoryCandidate.get();
        resourcesProcessor.process(sourceDir, this.outputDirectory, this);
        Boolean outputToConsole = this.logHandler.getOutputToConsole() == null ? Boolean.TRUE : this.logHandler.getOutputToConsole();
        MemoryLogHandler memoryLogHandler = new MemoryLogHandler(outputToConsole, logRecord -> this.getLog().info((CharSequence)LogRecordFormatter.format((LogRecord)logRecord, (File)sourceDir)));
        asciidoctor.registerLogHandler((org.asciidoctor.log.LogHandler)memoryLogHandler);
        Logger.getLogger("asciidoctor").setUseParentHandlers(false);
        HashSet<File> uniquePaths = new HashSet<File>();
        for (File source : sourceFiles) {
            Destination destination = this.setDestinationPaths(source, optionsBuilder, sourceDir, this);
            File destinationPath = destination.path;
            if (!uniquePaths.add(destinationPath)) {
                Object destinationFile = destinationPath.getAbsolutePath();
                if (!destination.isOutput) {
                    String baseName = FilenameUtils.getBaseName((String)destinationPath.getName());
                    destinationFile = destinationPath.getParentFile().getAbsolutePath() + File.separator + baseName + ".*";
                }
                this.getLog().warn((CharSequence)("Duplicated destination found: overwriting file: " + (String)destinationFile));
            }
            this.convertFile(asciidoctor, optionsBuilder.build(), source);
            try {
                new LogRecordsProcessors(this.logHandler, sourceDir, errorMessage -> this.getLog().error((CharSequence)errorMessage)).processLogRecords(memoryLogHandler);
            }
            catch (Exception exception) {
                throw new MojoExecutionException(exception.getMessage());
            }
        }
    }

    public Optional<File> findSourceDirectory(File initialSourceDirectory, File baseDir) {
        Optional<File> sourceDirCandidate = new SourceDirectoryFinder(initialSourceDirectory, baseDir, candidate -> {
            String candidateName = candidate.toString();
            if (this.isRelativePath(candidateName)) {
                candidateName = candidateName.substring(2);
            }
            this.getLog().info((CharSequence)("sourceDirectory " + candidateName + " does not exist"));
        }).find();
        return sourceDirCandidate;
    }

    private boolean isRelativePath(String candidateName) {
        return candidateName.startsWith("./") || candidateName.startsWith(".\\");
    }

    public Destination setDestinationPaths(File sourceFile, OptionsBuilder optionsBuilder, File sourceDirectory, AsciidoctorMojo configuration) throws MojoExecutionException {
        try {
            if (configuration.getBaseDir() != null) {
                optionsBuilder.baseDir(configuration.getBaseDir());
            } else if (configuration.isRelativeBaseDir()) {
                optionsBuilder.baseDir(sourceFile.getParentFile());
            } else {
                optionsBuilder.baseDir(sourceDirectory);
            }
            File outputDir = configuration.getOutputDirectory();
            if (configuration.isPreserveDirectories()) {
                String candidatePath = sourceFile.getParentFile().getCanonicalPath().substring(sourceDirectory.getCanonicalPath().length());
                File relativePath = new File(outputDir.getCanonicalPath() + candidatePath);
                optionsBuilder.toDir(relativePath);
            } else {
                optionsBuilder.toDir(outputDir);
            }
            File outputFile = configuration.getOutputFile();
            String toDir = (String)optionsBuilder.build().map().get("to_dir");
            if (outputFile != null) {
                optionsBuilder.toFile(outputFile);
                return outputFile.isAbsolute() ? new Destination(outputFile, true) : new Destination(new File(toDir, outputFile.getPath()), true);
            }
            return new Destination(new File(toDir, sourceFile.getName()), false);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to locate output directory", (Exception)e);
        }
    }

    protected Asciidoctor getAsciidoctorInstance(String gemPath) throws MojoExecutionException {
        String gemHomeExpected;
        Ruby rubyInstance;
        AsciidoctorJRuby asciidoctor;
        block8: {
            if (gemPath == null) {
                asciidoctor = AsciidoctorJRuby.Factory.create();
            } else {
                String normalizedGemPath = File.separatorChar == '\\' ? gemPath.replaceAll("\\\\", "/") : gemPath;
                asciidoctor = AsciidoctorJRuby.Factory.create((String)normalizedGemPath);
            }
            rubyInstance = null;
            try {
                rubyInstance = (Ruby)JRubyRuntimeContext.class.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                if (rubyInstance != null) break block8;
                try {
                    rubyInstance = (Ruby)JRubyRuntimeContext.class.getMethod("get", Asciidoctor.class).invoke(null, asciidoctor);
                }
                catch (Exception e1) {
                    throw new MojoExecutionException("Failed to invoke get(AsciiDoctor) for JRubyRuntimeContext", e1);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to invoke get for JRubyRuntimeContext", e);
            }
        }
        String gemHome = rubyInstance.evalScriptlet("ENV['GEM_HOME']").toString();
        String string = gemHomeExpected = gemPath == null || "".equals(gemPath) ? "" : gemPath.split(File.pathSeparator)[0];
        if (!"".equals(gemHome) && !gemHomeExpected.equals(gemHome)) {
            this.getLog().warn((CharSequence)("Using inherited external environment to resolve gems (" + gemHome + "), i.e. build is platform dependent!"));
        }
        return asciidoctor;
    }

    protected List<File> findSourceFiles(File sourceDirectory) {
        if (this.sourceDocumentName != null) {
            return Arrays.asList(new File(sourceDirectory, this.sourceDocumentName));
        }
        Path sourceDirectoryPath = sourceDirectory.toPath();
        SourceDocumentFinder finder = new SourceDocumentFinder();
        return this.sourceDocumentExtensions.isEmpty() ? finder.find(sourceDirectoryPath) : finder.find(sourceDirectoryPath, this.sourceDocumentExtensions);
    }

    protected void convertFile(Asciidoctor asciidoctor, Options options, File f) {
        asciidoctor.convertFile(f, options);
        this.logConvertedFile(f);
    }

    protected void logConvertedFile(File f) {
        this.getLog().info((CharSequence)("Converted " + f.getAbsolutePath()));
    }

    protected boolean ensureOutputExists() {
        if (!this.outputDirectory.exists()) {
            return this.outputDirectory.mkdirs();
        }
        return true;
    }

    protected OptionsBuilder createOptionsBuilder(AsciidoctorMojo configuration, AttributesBuilder attributesBuilder) {
        OptionsBuilder optionsBuilder = Options.builder().backend(configuration.getBackend()).safe(SafeMode.UNSAFE).standalone(configuration.standalone).mkDirs(true);
        if (!StringUtils.isBlank((CharSequence)configuration.getEruby())) {
            optionsBuilder.eruby(configuration.getEruby());
        }
        if (configuration.isSourcemap()) {
            optionsBuilder.option("sourcemap", (Object)true);
        }
        if (configuration.isCatalogAssets()) {
            optionsBuilder.option("catalog_assets", (Object)true);
        }
        if (!configuration.isTemplateCache()) {
            optionsBuilder.option("template_cache", (Object)false);
        }
        if (configuration.getDoctype() != null) {
            optionsBuilder.docType(this.doctype);
        }
        if (configuration.getTemplateEngine() != null) {
            optionsBuilder.templateEngine(this.templateEngine);
        }
        if (!configuration.getTemplateDirs().isEmpty()) {
            optionsBuilder.templateDirs(this.templateDirs.toArray(new File[0]));
        }
        optionsBuilder.attributes(attributesBuilder.build());
        return optionsBuilder;
    }

    protected AttributesBuilder createAttributesBuilder(AsciidoctorMojo configuration, MavenProject mavenProject) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        if (configuration.isEmbedAssets()) {
            attributesBuilder.linkCss(false);
            attributesBuilder.dataUri(true);
        }
        AsciidoctorHelper.addProperties((Properties)mavenProject.getProperties(), (AttributesBuilder)attributesBuilder);
        AsciidoctorHelper.addAttributes(configuration.getAttributes(), (AttributesBuilder)attributesBuilder);
        if (StringUtils.isNotBlank((CharSequence)configuration.getAttributesChain())) {
            this.getLog().info((CharSequence)("Attributes: " + this.attributesChain));
            attributesBuilder.arguments(this.attributesChain);
        }
        return attributesBuilder;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = new File(outputFile);
    }

    public String getBackend() {
        return this.backend;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(String templateEngine) {
        this.templateEngine = templateEngine;
    }

    public List<String> getSourceDocumentExtensions() {
        return this.sourceDocumentExtensions;
    }

    public void setSourceDocumentExtensions(List<String> sourceDocumentExtensions) {
        this.sourceDocumentExtensions = sourceDocumentExtensions;
    }

    public String getEruby() {
        return this.eruby;
    }

    public void setEruby(String eruby) {
        this.eruby = eruby;
    }

    public String getSourceDocumentName() {
        return this.sourceDocumentName;
    }

    public void setSourceDocumentName(String sourceDocumentName) {
        this.sourceDocumentName = sourceDocumentName;
    }

    public boolean isEmbedAssets() {
        return this.embedAssets;
    }

    public void setEmbedAssets(boolean embedAssets) {
        this.embedAssets = embedAssets;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public void setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public String getGemPath() {
        return this.gemPath;
    }

    public void setGemPath(String gemPath) {
        this.gemPath = gemPath;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setPreserveDirectories(boolean preserveDirectories) {
        this.preserveDirectories = preserveDirectories;
    }

    public void setRelativeBaseDir(boolean relativeBaseDir) {
        this.relativeBaseDir = relativeBaseDir;
    }

    public List<ExtensionConfiguration> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<ExtensionConfiguration> extensions) {
        this.extensions = extensions;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public boolean isEnableVerbose() {
        return this.enableVerbose;
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public void setEnableVerbose(boolean enableVerbose) {
        this.enableVerbose = enableVerbose;
    }

    public boolean isSourcemap() {
        return this.sourcemap;
    }

    public boolean isCatalogAssets() {
        return this.catalogAssets;
    }

    public boolean isTemplateCache() {
        return this.templateCache;
    }

    public List<File> getTemplateDirs() {
        return this.templateDirs;
    }

    public String getAttributesChain() {
        return this.attributesChain;
    }

    public boolean isRelativeBaseDir() {
        return this.relativeBaseDir;
    }

    public boolean isPreserveDirectories() {
        return this.preserveDirectories;
    }

    class Destination {
        final File path;
        final boolean isOutput;

        Destination(File destination, boolean isSource) {
            this.path = destination;
            this.isOutput = isSource;
        }
    }
}

