/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.process;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.asciidoctor.maven.AsciidoctorMojo;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.model.Resource;
import org.asciidoctor.maven.process.ResourcesProcessor;
import org.codehaus.plexus.util.DirectoryScanner;

@Named
public class CopyResourcesProcessor
implements ResourcesProcessor {
    public static String[] IGNORED_FILE_NAMES = new String[]{"docinfo.html", "docinfo-header.html", "docinfo-footer.html", "*-docinfo.html", "*-docinfo-header.html", "*-docinfo-footer.html", "docinfo.xml", "docinfo-header.xml", "docinfo-footer.xml", "*-docinfo.xml", "*-docinfo-header.xml", "*-docinfo-footer.xml"};
    private static String[] DEFAULT_ASCIIDOC_EXTENSIONS = new String[]{"**/*.adoc", "**/*.ad", "**/*.asc", "**/*.asciidoc"};
    private static String[] INTERNAL_FOLDERS_AND_FILES_PATTERNS = new String[]{"**/_*.*", "**/_*", "**/.*", "**/_*/**/*.*"};

    @Override
    public void process(File sourceRootDirectory, File outputRootDirectory, AsciidoctorMojo configuration) {
        List<Resource> finalResources = this.prepareResources(sourceRootDirectory, configuration);
        this.copyResources(finalResources, outputRootDirectory, configuration);
    }

    private List<Resource> prepareResources(File sourceDirectory, AsciidoctorMojo configuration) {
        ArrayList<Resource> resources;
        ArrayList<Resource> arrayList = resources = configuration.getResources() != null ? configuration.getResources() : new ArrayList<Resource>();
        if (resources.isEmpty()) {
            Resource resource = new Resource();
            resource.setDirectory(sourceDirectory.getAbsolutePath());
            if (StringUtils.isNotBlank((CharSequence)configuration.getSourceDocumentName())) {
                resource.getExcludes().add(configuration.getSourceDocumentName());
            }
            resources.add(resource);
        }
        for (Resource resource : resources) {
            ArrayList<Object> excludes = new ArrayList<Object>();
            for (String value : INTERNAL_FOLDERS_AND_FILES_PATTERNS) {
                excludes.add(value);
            }
            for (String value : IGNORED_FILE_NAMES) {
                excludes.add("**/" + value);
            }
            for (String value : DEFAULT_ASCIIDOC_EXTENSIONS) {
                excludes.add(value);
            }
            for (String docExtension : configuration.getSourceDocumentExtensions()) {
                resource.getExcludes().add("**/*." + docExtension);
            }
            excludes.removeAll(resource.getIncludes());
            resource.getExcludes().addAll(excludes);
        }
        return resources;
    }

    private void copyResources(List<Resource> resources, File outputDirectory, AsciidoctorMojo configuration) {
        resources.stream().map(resource -> {
            File candidate = new File(resource.getDirectory());
            File sourceDir = candidate.isAbsolute() ? candidate : new File(configuration.getProjectDirectory(), resource.getDirectory());
            Resource sanitizedResource = new Resource();
            sanitizedResource.setDirectory(sourceDir.getAbsolutePath());
            sanitizedResource.setTargetPath(resource.getTargetPath());
            sanitizedResource.setIncludes(resource.getIncludes());
            sanitizedResource.setExcludes(resource.getExcludes());
            return sanitizedResource;
        }).filter(resource -> new File(resource.getDirectory()).exists()).forEach(resource -> {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(resource.getDirectory());
            if (resource.getIncludes().isEmpty()) {
                directoryScanner.setIncludes(new String[]{"**/*.*", "**/*"});
            } else {
                directoryScanner.setIncludes(resource.getIncludes().toArray(new String[0]));
            }
            directoryScanner.setExcludes(resource.getExcludes().toArray(new String[0]));
            directoryScanner.setFollowSymlinks(false);
            directoryScanner.scan();
            for (String includedFile : directoryScanner.getIncludedFiles()) {
                File source = new File(directoryScanner.getBasedir(), includedFile);
                this.copyFileToDirectory(source, (Resource)resource, outputDirectory);
            }
        });
    }

    private void copyFileToDirectory(File source, Resource resource, File outputDirectory) {
        try {
            File target = resource.getTargetPath() == null ? outputDirectory : CopyResourcesProcessor.composeTargetPath(resource, outputDirectory);
            Path sourceDirectoryPath = new File(resource.getDirectory()).toPath();
            Path sourcePath = source.toPath();
            Path relativize = sourceDirectoryPath.relativize(sourcePath);
            if (relativize.getParent() == null) {
                FileUtils.copyFileToDirectory((File)source, (File)target);
            } else {
                Path realTarget = target.toPath().resolve(relativize.getParent());
                File realTargetFile = realTarget.toFile();
                FileUtils.forceMkdir((File)realTargetFile);
                FileUtils.copyFileToDirectory((File)source, (File)realTargetFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File composeTargetPath(Resource resource, File outputDirectory) {
        File targetFile = new File(resource.getTargetPath());
        return targetFile.isAbsolute() ? targetFile : new File(outputDirectory, resource.getTargetPath());
    }
}

