/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.refresh;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.asciidoctor.maven.AsciidoctorRefreshMojo;
import org.asciidoctor.maven.process.ResourcesProcessor;
import org.asciidoctor.maven.refresh.AbstractFileAlterationListenerAdaptor;
import org.asciidoctor.maven.refresh.TimeCounter;

public class AdditionalSourceFileAlterationListenerAdaptor
extends AbstractFileAlterationListenerAdaptor {
    private static final ResourcesProcessor EMPTY_RESOURCES_PROCESSOR = (sourcesDir, outputDir, configuration) -> {};

    public AdditionalSourceFileAlterationListenerAdaptor(AsciidoctorRefreshMojo mojo, Runnable postAction, Log log) {
        super(mojo, postAction, log);
    }

    @Override
    synchronized void processFile(File file, String actionName) {
        this.getLog().info((CharSequence)String.format("Additional source file %s %s", file.getAbsolutePath(), actionName));
        this.getLog().info((CharSequence)"Full refresh");
        long timeInMillis = TimeCounter.timed(() -> {
            try {
                this.getMojo().processAllSources(EMPTY_RESOURCES_PROCESSOR);
            }
            catch (MojoExecutionException e) {
                this.getLog().error((Throwable)e);
            }
        });
        this.getLog().info((CharSequence)("Converted document(s) in " + timeInMillis + "ms"));
    }
}

