/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.refresh;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.asciidoctor.maven.AsciidoctorRefreshMojo;
import org.asciidoctor.maven.commons.StringUtils;
import org.asciidoctor.maven.model.Resource;
import org.asciidoctor.maven.refresh.AbstractFileAlterationListenerAdaptor;
import org.asciidoctor.maven.refresh.TimeCounter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class ResourceCopyFileAlterationListenerAdaptor
extends AbstractFileAlterationListenerAdaptor {
    public ResourceCopyFileAlterationListenerAdaptor(AsciidoctorRefreshMojo mojo, Runnable postAction, Log log) {
        super(mojo, postAction, log);
    }

    @Override
    synchronized void processFile(File file, String actionName) {
        this.getLog().info((CharSequence)String.format("Resource file %s %s", file.getAbsolutePath(), actionName));
        long timeInMillis = TimeCounter.timed(() -> {
            try {
                AsciidoctorRefreshMojo mojo = this.getMojo();
                File sourceDirectory = mojo.findSourceDirectory(mojo.getSourceDirectory(), mojo.getBaseDir()).get();
                File outputDirectory = mojo.getOutputDirectory();
                List<Resource> matchingResources = this.findMatchingResources(mojo.getResources(), file);
                if (matchingResources.isEmpty()) {
                    String relativePath = file.getParentFile().getCanonicalPath().substring(sourceDirectory.getCanonicalPath().length());
                    File destinationDirectory = new File(outputDirectory, relativePath);
                    FileUtils.forceMkdir((File)outputDirectory);
                    FileUtils.copyFileToDirectory((File)file, (File)destinationDirectory);
                } else {
                    for (Resource matchingResource : matchingResources) {
                        DirectoryScanner scanner = new DirectoryScanner();
                        File basedir = this.resourceDirectory(matchingResource);
                        scanner.setBasedir(basedir);
                        if (matchingResource.getIncludes().isEmpty()) {
                            scanner.setIncludes(new String[]{"**/**"});
                        } else {
                            scanner.setIncludes(matchingResource.getIncludes().toArray(new String[0]));
                        }
                        scanner.setExcludes(matchingResource.getExcludes().toArray(new String[0]));
                        scanner.scan();
                        if (!this.containsFile(scanner.getIncludedFiles(), basedir, file)) continue;
                        File destDir = StringUtils.isBlank((CharSequence)matchingResource.getTargetPath()) ? outputDirectory : new File(outputDirectory, matchingResource.getTargetPath());
                        FileUtils.forceMkdir((File)destDir);
                        FileUtils.copyFileToDirectory((File)file, (File)destDir);
                    }
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Could not copy file: " + file.getAbsolutePath()));
            }
        });
        this.getLog().info((CharSequence)("Copied resource in " + timeInMillis + "ms"));
    }

    private boolean containsFile(String[] includedFiles, File basedir, File file) {
        for (String includedFile : includedFiles) {
            if (!this.equalFiles(new File(basedir, includedFile), file)) continue;
            return true;
        }
        return false;
    }

    private List<Resource> findMatchingResources(List<Resource> resources, File file) {
        if (resources == null || resources.isEmpty()) {
            return Collections.emptyList();
        }
        return resources.stream().filter(resource -> {
            File resourceDirectory = this.resourceDirectory((Resource)resource);
            if (resource.getIncludes().isEmpty()) {
                return this.equalDirectories(resourceDirectory, file.getParentFile());
            }
            if (this.containsRecursiveIncludes((Resource)resource)) {
                return this.isSubDirectory(resourceDirectory, file);
            }
            return false;
        }).collect(Collectors.toList());
    }

    private boolean equalDirectories(File dir1, File dir2) {
        return dir1.isDirectory() && dir2.isDirectory() && this.equalFiles(dir1, dir2);
    }

    private boolean equalFiles(File file1, File file2) {
        try {
            return file1.getCanonicalPath().equals(file2.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    private File resourceDirectory(Resource resource) {
        File projectDirectory = this.getMojo().getProjectDirectory();
        return new File(projectDirectory, resource.getDirectory().replaceAll("\\\\", "/"));
    }

    private boolean containsRecursiveIncludes(Resource resource) {
        return resource.getIncludes().stream().anyMatch(include -> include.contains("**/") || include.contains("**\\"));
    }

    private boolean isSubDirectory(File parent, File file) {
        try {
            return file.getParentFile().getCanonicalPath().startsWith(parent.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }
}

