/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.jruby.ast.impl.NodeConverter;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyHashMapDecorator
implements Map<String, Object> {
    private final RubyHash rubyHash;
    private final Ruby rubyRuntime;
    private RubyClass abstractNodeClass;
    private Class rubyKeyType;

    public RubyHashMapDecorator(RubyHash rubyHash) {
        this(rubyHash, RubySymbol.class);
    }

    public RubyHashMapDecorator(RubyHash rubyHash, Class rubyKeyType) {
        this.rubyRuntime = rubyHash.getRuntime();
        this.rubyHash = rubyHash;
        if (rubyKeyType != RubySymbol.class && rubyKeyType != String.class) {
            throw new UnsupportedOperationException("key type must be either RubySymbol or String");
        }
        this.rubyKeyType = rubyKeyType;
    }

    private Object coerceKey(String key) {
        if (this.rubyKeyType == RubySymbol.class) {
            return this.rubyHash.getRuntime().getSymbolTable().getSymbol(key);
        }
        return key;
    }

    @Override
    public int size() {
        return this.createJavaMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        return this.rubyHash.containsKey(this.coerceKey((String)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rubyHash.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        Object value = this.rubyHash.get(this.coerceKey((String)key));
        return this.convertRubyValue(value);
    }

    @Override
    public Object put(String key, Object value) {
        Object oldValue = this.get(key);
        this.rubyHash.put(this.coerceKey(key), (Object)this.convertJavaValue(value));
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        Object oldValue = this.get(key);
        this.rubyHash.remove(this.coerceKey((String)key));
        return this.convertRubyValue(oldValue);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.rubyHash.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.createJavaMap().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.createJavaMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.createJavaMap().entrySet();
    }

    private Map<String, Object> createJavaMap() {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        Set rubyEntrySet = this.rubyHash.entrySet();
        for (Map.Entry o : rubyEntrySet) {
            String key = null;
            Object rubyKey = o.getKey();
            Object rubyValue = o.getValue();
            if (rubyKey instanceof RubySymbol) {
                key = ((RubySymbol)rubyKey).asJavaString();
            } else if (rubyKey instanceof RubyString) {
                key = ((RubyString)rubyKey).asJavaString();
            } else if (rubyKey instanceof String) {
                key = (String)rubyKey;
            } else if (!(rubyKey instanceof Long)) {
                throw new IllegalStateException("Did not expect key " + String.valueOf(rubyKey) + " of type " + String.valueOf(rubyKey.getClass()));
            }
            if (key == null) continue;
            Object value = this.convertRubyValue(rubyValue);
            copy.put(key, value);
        }
        return copy;
    }

    private Object convertRubyValue(Object rubyValue) {
        if (rubyValue == null) {
            return null;
        }
        if (rubyValue instanceof IRubyObject) {
            IRubyObject rubyObject = (IRubyObject)rubyValue;
            if (RubyModule.KindOf.DEFAULT_KIND_OF.isKindOf(rubyObject, (RubyModule)this.getAbstractNodeClass())) {
                return NodeConverter.createASTNode(rubyObject);
            }
            if (rubyObject instanceof RubySymbol) {
                return ":" + String.valueOf(rubyObject.asString());
            }
            return JavaEmbedUtils.rubyToJava((IRubyObject)((IRubyObject)rubyValue));
        }
        return rubyValue;
    }

    private RubyClass getAbstractNodeClass() {
        RubyClass ret = this.abstractNodeClass;
        if (ret == null) {
            this.abstractNodeClass = ret = this.rubyRuntime.getModule("Asciidoctor").getClass("AbstractNode");
        }
        return ret;
    }

    private IRubyObject convertJavaValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).startsWith(":")) {
            return this.rubyHash.getRuntime().getSymbolTable().getSymbol(((String)value).substring(1));
        }
        return JavaEmbedUtils.javaToRuby((Ruby)this.rubyHash.getRuntime(), (Object)value);
    }

    RubyHash getRubyHash() {
        return this.rubyHash;
    }
}

