/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.parser.AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Literal;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.TheOriginalJDTParserClass;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class Parser
extends TheOriginalJDTParserClass {
    private static final String ASPECTJ_DECLARATION_FACTORY = "org.aspectj.ajdt.internal.compiler.parser.DeclarationFactory";
    private static IDeclarationFactory declarationFactory;
    protected int aspectIntPtr;
    protected int[] aspectIntStack;
    private static final boolean AJ_DEBUG = false;

    static {
        try {
            Parser.initTables(Parser.class);
            declarationFactory = (IDeclarationFactory)Class.forName(ASPECTJ_DECLARATION_FACTORY).newInstance();
        }
        catch (IOException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Warning: AspectJ declaration factory class not found on classpath");
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initialize(boolean initializeNLS) {
        super.initialize(initializeNLS);
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initializeScanner() {
        this.scanner = new Scanner(false, false, this.options.getSeverity(256) != 256, this.options.sourceLevel, this.options.taskTags, this.options.taskPriorities, this.options.isTaskCaseSensitive);
    }

    void println(Object o) {
    }

    private void printStack(Object[] s, int p) {
        List<Object> list = Arrays.asList(s);
        System.out.println("  " + list.subList(0, p + 1));
    }

    private void printStack(int[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Integer.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(long[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Long.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(char[][] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(new String(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    public void display() {
    }

    @Override
    protected MethodDeclaration createMethodDeclaration(CompilationResult result) {
        return declarationFactory.createMethodDeclaration(result);
    }

    @Override
    protected ConstructorDeclaration createConstructorDeclaration(CompilationResult result) {
        return declarationFactory.createConstructorDeclaration(result);
    }

    @Override
    protected void consumeMethodInvocationName() {
        super.consumeMethodInvocationName();
        MessageSend m = (MessageSend)this.expressionStack[this.expressionPtr];
        if (CharOperation.equals(m.selector, "proceed".toCharArray())) {
            this.expressionStack[this.expressionPtr] = declarationFactory.createProceed(m);
        }
    }

    @Override
    protected void consumeToken(int type) {
        this.currentTokenStart = this.scanner.startPosition;
        super.consumeToken(type);
        switch (type) {
            case 27: {
                this.pushOnAspectIntStack(this.scanner.currentPosition - 1);
                this.pushOnAspectIntStack(this.scanner.startPosition);
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                this.pushIdentifier();
                this.scanner.commentPtr = -1;
            }
        }
    }

    protected void consumeAspectDeclaration() {
        this.consumeClassDeclaration();
    }

    protected void consumeAspectHeader() {
        this.consumeClassHeader();
    }

    protected void consumeAspectHeaderName(boolean isPrivileged) {
        TypeDeclaration aspectDecl = declarationFactory.createAspect(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                aspectDecl.bits |= 0x400;
            }
        } else {
            aspectDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.println("aspect header name: ");
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        aspectDecl.sourceEnd = (int)pos;
        aspectDecl.sourceStart = (int)(pos >>> 32);
        aspectDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        aspectDecl.declarationSourceStart = this.aspectIntStack[this.aspectIntPtr--];
        --this.aspectIntPtr;
        this.eatIdentifier();
        if (isPrivileged) {
            pos = this.eatIdentifier();
            declarationFactory.setPrivileged(aspectDecl, true);
        }
        aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        aspectDecl.modifiers = this.intStack[this.intPtr--];
        if (isPrivileged) {
            aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
            aspectDecl.modifiers |= this.intStack[this.intPtr--];
        }
        if (aspectDecl.modifiersSourceStart >= 0) {
            aspectDecl.declarationSourceStart = aspectDecl.modifiersSourceStart;
        }
        this.println("modifiers: " + aspectDecl.modifiers);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            aspectDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, aspectDecl.annotations, 0, length);
        }
        aspectDecl.bodyStart = aspectDecl.sourceEnd + 1;
        this.pushOnAstStack(aspectDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = aspectDecl.bodyStart;
            this.currentElement = this.currentElement.add(aspectDecl, 0);
            this.lastIgnoredToken = -1;
        }
        aspectDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected void consumeAspectHeaderNameWithTypeParameters(boolean isPriviliged) {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private long eatIdentifier() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        --this.identifierPtr;
        --this.identifierLengthPtr;
        return pos;
    }

    protected void consumeAspectHeaderRest() {
        this.concatNodeLists();
        this.display();
        ASTNode pseudoTokens = this.popPseudoTokens("{");
        this.println("pseudo: " + pseudoTokens);
        TypeDeclaration aspectDecl = (TypeDeclaration)this.astStack[this.astPtr];
        declarationFactory.setDominatesPatternFrom(aspectDecl, pseudoTokens, this);
        declarationFactory.setPerClauseFrom(aspectDecl, pseudoTokens, this);
    }

    protected void consumePointcutDeclaration() {
        this.consumePointcutDesignatorOnDeclaration();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    public int getCurrentTokenStart() {
        return this.currentTokenStart;
    }

    protected void consumeEmptyPointcutDeclaration() {
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        pcutDecl.bodyEnd = this.endStatementPosition;
    }

    protected void consumePointcutHeader() {
        MethodDeclaration ret = declarationFactory.createPointcutDeclaration(this.compilationUnit.compilationResult);
        long pos = this.identifierPositionStack[this.identifierPtr];
        ret.sourceStart = (int)(pos >>> 32);
        ret.selector = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ret.javadoc = this.javadoc;
        this.javadoc = null;
        this.eatIdentifier();
        ret.declarationSourceStart = this.intStack[this.intPtr--];
        ret.modifiers = this.intStack[this.intPtr--];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            ret.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, ret.annotations, 0, length);
        }
        this.pushOnAstStack(ret);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeAroundDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeAroundHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
    }

    protected void consumeAroundHeaderName() {
        int length;
        MethodDeclaration adviceDecl = declarationFactory.createAroundAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        adviceDecl.returnType = returnType;
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
    }

    protected void consumePointcutDesignatorOnAdvice() {
        ASTNode des = this.popPointcutDesignator("{");
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnAdvice(adviceDecl, des);
        adviceDecl.sourceEnd = des.sourceEnd;
        adviceDecl.bodyStart = des.sourceEnd + 1;
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumePointcutDesignatorOnDeclaration() {
        ASTNode des = this.popPointcutDesignator(";");
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnPointcut(pcutDecl, des);
        pcutDecl.sourceEnd = des.sourceEnd;
        pcutDecl.bodyStart = des.sourceEnd + 1;
        pcutDecl.bodyEnd = this.endPosition;
        pcutDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceDeclaration() {
        this.consumeMethodDeclaration(true, false);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeaderName(boolean isAfter) {
        int length;
        MethodDeclaration adviceDecl = isAfter ? declarationFactory.createAfterAdviceDeclaration(this.compilationUnit.compilationResult) : declarationFactory.createBeforeAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeExtraParameterWithFormal() {
        Argument arg = (Argument)this.astStack[this.astPtr--];
        --this.astLengthPtr;
        declarationFactory.setExtraArgument((MethodDeclaration)this.astStack[this.astPtr], arg);
        this.consumeExtraParameterNoFormal();
    }

    protected void consumeExtraParameterNoFormal() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.isAfterAdvice(adviceDecl);
        if (CharOperation.equals(name, "throwing".toCharArray())) {
            declarationFactory.setAfterThrowingAdviceKind(adviceDecl);
        } else if (CharOperation.equals(name, "returning".toCharArray())) {
            declarationFactory.setAfterReturningAdviceKind(adviceDecl);
        } else {
            this.problemReporter().parseError(start, end, this.currentToken, name, String.valueOf(name), new String[]{"throwing", "returning", ":"});
        }
    }

    protected void consumeClassBodyDeclarationInAspect() {
    }

    protected void consumeDeclareDeclaration() {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        MethodDeclaration declareDecl = declarationFactory.createDeclareDeclaration(this.compilationUnit.compilationResult, tokens, this);
        this.display();
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotation(char kind) {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        Annotation[] annotations = new Annotation[1];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, annotations, 0, length);
        }
        MethodDeclaration declareDecl = declarationFactory.createDeclareAnnotationDeclaration(this.compilationUnit.compilationResult, tokens, annotations[0], this, kind);
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotationHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken("@", 0, false);
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeDeclareHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeInterTypeFieldHeader(boolean hasTypeParameters) {
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] identifierName = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        this.display();
        int decSourceStart = this.intStack[this.intPtr--];
        int fieldModifiers = this.intStack[this.intPtr--];
        MethodDeclaration dec = declarationFactory.createInterTypeFieldDeclaration(this.compilationUnit.compilationResult, onType);
        dec.returnType = returnType;
        dec.sourceStart = start;
        dec.sourceEnd = end;
        declarationFactory.setSelector(dec, identifierName);
        dec.declarationSourceStart = decSourceStart;
        declarationFactory.setDeclaredModifiers(dec, fieldModifiers);
        dec.bodyEnd = this.endPosition;
        dec.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            dec.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, dec.annotations, 0, length);
        }
        this.pushOnAstStack(dec);
        this.println("consumed field: " + dec);
        this.display();
    }

    protected void consumeExitITDVariableWithoutInitializer() {
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setInitialization(itdDecl, null);
    }

    protected void consumeExitITDVariableWithInitializer() {
        --this.expressionLengthPtr;
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        Expression initialization = this.expressionStack[this.expressionPtr--];
        declarationFactory.setInitialization(itdDecl, initialization);
        itdDecl.declarationSourceEnd = initialization.sourceEnd;
    }

    protected void consumeInterTypeFieldDeclaration() {
        MethodDeclaration dec = (MethodDeclaration)this.astStack[this.astPtr];
        dec.bodyEnd = this.endPosition;
        dec.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    protected void consumeInterTypeMethodDeclaration(boolean isNotAbstract) {
        this.consumeMethodDeclaration(isNotAbstract, false);
    }

    protected void consumeInterTypeMethodHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeConstructorDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeInterTypeConstructorHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeMethodHeaderName(boolean hasMethodTypeParameters, boolean hasGenericTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeMethodDeclaration(this.compilationUnit.compilationResult);
        char[] name = this.identifierStack[this.identifierPtr];
        long selectorSource = this.identifierPositionStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasGenericTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        md.returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        if (hasMethodTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        declarationFactory.setOnType(md, onType);
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        md.sourceStart = (int)(selectorSource >>> 32);
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        declarationFactory.setSelector(md, name);
        this.listLength = 0;
        md.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType || this.scanner.getLineNumber(md.returnType.sourceStart) == this.scanner.getLineNumber(md.sourceStart)) {
                this.lastCheckPoint = md.bodyStart;
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumeInterTypeConstructorHeaderName(boolean hasConstructorTypeParameters, boolean hasTargetTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeConstructorDeclaration(this.compilationUnit.compilationResult);
        if (!hasTargetTypeParameters) {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(md, onType);
        this.println("got onType: " + onType);
        this.display();
        --this.intPtr;
        md.returnType = TypeReference.baseTypeReference(6, 0, null);
        if (hasConstructorTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        md.sourceStart = onType.sourceStart;
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        this.listLength = 0;
        declarationFactory.setSelector(md, (String.valueOf(new String(CharOperation.concatWith(onType.getTypeName(), '_'))) + "_new").toCharArray());
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType) {
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumePseudoToken(String value) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(value, 0, false);
    }

    protected void consumePseudoToken(String value, int popFromIntStack, boolean isIdentifier) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.intPtr -= popFromIntStack;
        int start = this.currentTokenStart;
        int end = start + value.length() - 1;
        ASTNode tok = declarationFactory.createPseudoToken(this, value, isIdentifier);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIdentifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(name), true);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIf() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Expression expr = this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        this.println("expr: " + expr);
        int start = this.intStack[this.intPtr--];
        ASTNode tok = declarationFactory.createIfPseudoToken(this, expr);
        tok.sourceStart = start;
        tok.sourceEnd = this.rParenPos;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenLiteral() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Literal literal = (Literal)this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(literal.source()), false);
        declarationFactory.setLiteralKind(tok, "string");
        tok.sourceStart = literal.sourceStart;
        tok.sourceEnd = literal.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenModifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(Modifier.toString(this.modifiers), 0, true);
        this.modifiers = 0;
    }

    protected void consumePseudoTokenPrimitiveType() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        TypeReference type = this.getTypeReference(0);
        ASTNode tok = declarationFactory.createPseudoToken(this, type.toString(), true);
        tok.sourceStart = type.sourceStart;
        tok.sourceEnd = type.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokens() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.optimizedConcatNodeLists();
    }

    @Override
    protected void consumeRule(int act) {
        switch (act) {
            case 39: {
                this.consumePrimitiveType();
                break;
            }
            case 53: {
                this.consumeReferenceType();
                break;
            }
            case 57: {
                this.consumeClassOrInterfaceName();
                break;
            }
            case 58: {
                this.consumeClassOrInterface();
                break;
            }
            case 59: {
                this.consumeGenericType();
                break;
            }
            case 60: {
                this.consumeGenericTypeWithDiamond();
                break;
            }
            case 61: {
                this.consumeArrayTypeWithTypeArgumentsName();
                break;
            }
            case 62: {
                this.consumePrimitiveArrayType();
                break;
            }
            case 63: {
                this.consumeNameArrayType();
                break;
            }
            case 64: {
                this.consumeGenericTypeNameArrayType();
                break;
            }
            case 65: {
                this.consumeGenericTypeArrayType();
                break;
            }
            case 71: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 72: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 81: {
                this.consumeQualifiedName();
                break;
            }
            case 84: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 89: {
                this.consumeUnannotatableQualifiedName();
                break;
            }
            case 90: {
                this.consumeQualifiedName(false);
                break;
            }
            case 91: {
                this.consumeQualifiedName(true);
                break;
            }
            case 92: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 96: {
                this.consumeOneMoreTypeAnnotation();
                break;
            }
            case 97: {
                this.consumeTypeAnnotation();
                break;
            }
            case 98: {
                this.consumeTypeAnnotation();
                break;
            }
            case 99: {
                this.consumeTypeAnnotation();
                break;
            }
            case 100: {
                this.consumeAnnotationName();
                break;
            }
            case 101: {
                this.consumeNormalAnnotation(true);
                break;
            }
            case 102: {
                this.consumeMarkerAnnotation(true);
                break;
            }
            case 103: {
                this.consumeSingleMemberAnnotation(true);
                break;
            }
            case 104: {
                this.consumeNonTypeUseName();
                break;
            }
            case 105: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 106: {
                this.consumeExplicitThisParameter(false);
                break;
            }
            case 107: {
                this.consumeExplicitThisParameter(true);
                break;
            }
            case 108: {
                this.consumeVariableDeclaratorIdParameter();
                break;
            }
            case 109: {
                this.consumeCompilationUnit();
                break;
            }
            case 110: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 111: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 112: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 113: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 114: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 115: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 116: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 117: {
                this.consumeEmptyInternalCompilationUnit();
                break;
            }
            case 118: {
                this.consumeInternalCompilationUnitWithModuleDeclaration();
                break;
            }
            case 119: {
                this.consumeInternalCompilationUnitWithModuleDeclaration();
                break;
            }
            case 120: {
                this.consumeModuleDeclaration();
                break;
            }
            case 121: {
                this.consumeModuleHeader();
                break;
            }
            case 123: {
                this.consumeModuleModifiers();
                break;
            }
            case 126: {
                this.consumeEmptyModuleStatementsOpt();
                break;
            }
            case 129: {
                this.consumeModuleStatements();
                break;
            }
            case 135: {
                this.consumeRequiresStatement();
                break;
            }
            case 136: {
                this.consumeSingleRequiresModuleName();
                break;
            }
            case 137: {
                this.consumeModifiers();
                break;
            }
            case 138: {
                this.consumeDefaultModifiers();
                break;
            }
            case 140: {
                this.consumeModifiers2();
                break;
            }
            case 143: {
                this.consumeExportsStatement();
                break;
            }
            case 144: {
                this.consumeExportsHeader();
                break;
            }
            case 146: {
                this.consumeTargetModuleList();
                break;
            }
            case 147: {
                this.consumeSingleTargetModuleName();
                break;
            }
            case 149: {
                this.consumeTargetModuleNameList();
                break;
            }
            case 150: {
                this.consumeSinglePkgName();
                break;
            }
            case 151: {
                this.consumeOpensStatement();
                break;
            }
            case 152: {
                this.consumeOpensHeader();
                break;
            }
            case 153: {
                this.consumeUsesStatement();
                break;
            }
            case 154: {
                this.consumeUsesHeader();
                break;
            }
            case 155: {
                this.consumeProvidesStatement();
                break;
            }
            case 156: {
                this.consumeProvidesInterface();
                break;
            }
            case 157: {
                this.consumeSingleServiceImplName();
                break;
            }
            case 159: {
                this.consumeServiceImplNameList();
                break;
            }
            case 160: {
                this.consumeWithClause();
                break;
            }
            case 161: {
                this.consumeReduceImports();
                break;
            }
            case 162: {
                this.consumeEnterCompilationUnit();
                break;
            }
            case 184: {
                this.consumeCatchHeader();
                break;
            }
            case 186: {
                this.consumeImportDeclarations();
                break;
            }
            case 188: {
                this.consumeTypeDeclarations();
                break;
            }
            case 189: {
                this.consumePackageDeclaration();
                break;
            }
            case 190: {
                this.consumePackageDeclarationNameWithModifiers();
                break;
            }
            case 191: {
                this.consumePackageDeclarationName();
                break;
            }
            case 192: {
                this.consumePackageComment();
                break;
            }
            case 197: {
                this.consumeImportDeclaration();
                break;
            }
            case 198: {
                this.consumeSingleTypeImportDeclarationName();
                break;
            }
            case 199: {
                this.consumeImportDeclaration();
                break;
            }
            case 200: {
                this.consumeTypeImportOnDemandDeclarationName();
                break;
            }
            case 203: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 207: {
                this.consumeModifiers2();
                break;
            }
            case 220: {
                this.consumeAnnotationAsModifier();
                break;
            }
            case 233: {
                this.consumeAspectDeclaration();
                break;
            }
            case 234: {
                this.consumeAspectHeader();
                break;
            }
            case 237: {
                this.consumeAspectHeaderNameWithTypeParameters(false);
                break;
            }
            case 238: {
                this.consumeAspectHeaderNameWithTypeParameters(true);
                break;
            }
            case 239: {
                this.consumeAspectHeaderName(false);
                break;
            }
            case 240: {
                this.consumeAspectHeaderName(true);
                break;
            }
            case 242: {
                this.consumeAspectHeaderRest();
                break;
            }
            case 243: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 246: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 247: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 248: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 249: {
                this.consumeClassBodyDeclarationInAspect();
                break;
            }
            case 253: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 263: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 265: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 266: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 267: {
                this.consumeMethodHeader();
                break;
            }
            case 268: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 269: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 270: {
                this.consumeEmptyPointcutDeclaration();
                break;
            }
            case 271: {
                this.consumePointcutDeclaration();
                break;
            }
            case 272: {
                this.consumePointcutHeader();
                break;
            }
            case 275: {
                this.consumeAroundDeclaration();
                break;
            }
            case 276: {
                this.consumeAroundHeader();
                break;
            }
            case 277: {
                this.consumeAroundHeaderName();
                break;
            }
            case 278: {
                this.consumeAroundHeaderNameMissingReturnType();
                break;
            }
            case 279: {
                this.consumeBasicAdviceDeclaration();
                break;
            }
            case 282: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 283: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 284: {
                this.consumeBasicAdviceHeaderName(false);
                break;
            }
            case 285: {
                this.consumeBasicAdviceHeaderName(true);
                break;
            }
            case 286: {
                this.consumeExtraParameterWithFormal();
                break;
            }
            case 287: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 288: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 290: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 291: {
                this.consumeZeroTypeAnnotations();
                this.consumeQualifiedName();
                break;
            }
            case 296: {
                this.consumeInterTypeMethodDeclaration(true);
                break;
            }
            case 297: {
                this.consumeInterTypeMethodHeader();
                break;
            }
            case 298: {
                this.consumeInterTypeMethodHeaderName(false, false);
                break;
            }
            case 299: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 300: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 301: {
                this.consumeInterTypeMethodHeaderName(false, true);
                break;
            }
            case 302: {
                this.consumeInterTypeMethodHeaderName(true, false);
                break;
            }
            case 303: {
                this.consumeInterTypeMethodHeaderName(true, true);
                break;
            }
            case 304: {
                this.consumeInterTypeMethodDeclaration(false);
                break;
            }
            case 305: {
                this.convertTypeParametersToSingleTypeReferences();
                break;
            }
            case 306: {
                this.consumeInterTypeConstructorDeclaration();
                break;
            }
            case 307: {
                this.consumeInterTypeConstructorHeader();
                break;
            }
            case 308: {
                this.consumeInterTypeConstructorHeaderName(false, false);
                break;
            }
            case 309: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 310: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 311: {
                this.consumeInterTypeConstructorHeaderName(true, false);
                break;
            }
            case 312: {
                this.consumeInterTypeConstructorHeaderName(false, true);
                break;
            }
            case 313: {
                this.consumeInterTypeConstructorHeaderName(true, true);
                break;
            }
            case 314: {
                this.consumeInterTypeFieldDeclaration();
                break;
            }
            case 315: {
                this.consumeInterTypeFieldHeader(false);
                break;
            }
            case 316: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("*");
                break;
            }
            case 317: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("+");
                break;
            }
            case 318: {
                this.consumeInterTypeFieldHeader(true);
                break;
            }
            case 319: {
                this.consumeExitITDVariableWithoutInitializer();
                break;
            }
            case 320: {
                this.consumeExitITDVariableWithInitializer();
                break;
            }
            case 322: {
                this.consumeDeclareDeclaration();
                break;
            }
            case 323: {
                this.consumeDeclareHeader();
                break;
            }
            case 324: {
                this.consumeDeclareAnnotation(' ');
                break;
            }
            case 325: {
                this.consumeDeclareAnnotation('+');
                break;
            }
            case 326: {
                this.consumeDeclareAnnotation('-');
                break;
            }
            case 329: {
                this.consumeDeclareAnnotationHeader();
                break;
            }
            case 332: {
                this.consumePseudoTokens();
                break;
            }
            case 333: {
                this.consumePseudoTokens();
                break;
            }
            case 335: {
                this.consumePseudoTokens();
                break;
            }
            case 336: {
                this.consumePseudoToken(":");
                break;
            }
            case 337: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 338: {
                this.consumePseudoToken("(");
                break;
            }
            case 339: {
                this.consumePseudoToken(")");
                break;
            }
            case 340: {
                this.consumePseudoToken(".");
                break;
            }
            case 341: {
                this.consumePseudoToken("*");
                break;
            }
            case 342: {
                this.consumePseudoToken("+");
                break;
            }
            case 343: {
                this.consumePseudoToken("=");
                break;
            }
            case 344: {
                this.consumePseudoToken("&&");
                break;
            }
            case 345: {
                this.consumePseudoToken("||");
                break;
            }
            case 346: {
                this.consumePseudoToken("!");
                break;
            }
            case 347: {
                this.consumePseudoToken(",");
                break;
            }
            case 348: {
                this.consumePseudoToken("[");
                break;
            }
            case 349: {
                this.consumePseudoToken("]");
                break;
            }
            case 350: {
                this.consumePseudoToken("@");
                break;
            }
            case 351: {
                this.consumePseudoToken("...");
                break;
            }
            case 352: {
                this.consumePseudoToken("?");
                break;
            }
            case 353: {
                this.consumePseudoToken("<");
                break;
            }
            case 354: {
                this.consumePseudoToken(">");
                break;
            }
            case 355: {
                this.consumePseudoToken(">>");
                break;
            }
            case 356: {
                this.consumePseudoToken(">>>");
                break;
            }
            case 357: {
                this.consumePseudoToken("&");
                break;
            }
            case 358: {
                this.consumePseudoToken("!=");
                break;
            }
            case 359: {
                this.consumePseudoTokenPrimitiveType();
                break;
            }
            case 360: {
                this.consumePseudoTokenModifier();
                break;
            }
            case 361: {
                this.consumePseudoTokenLiteral();
                break;
            }
            case 362: {
                this.consumePseudoToken("this", 1, true);
                break;
            }
            case 363: {
                this.consumePseudoToken("class", 1, true);
                break;
            }
            case 364: {
                this.consumePseudoToken("super", 1, true);
                break;
            }
            case 365: {
                this.consumePseudoTokenIf();
                break;
            }
            case 366: {
                this.consumePseudoToken("assert", 1, true);
                break;
            }
            case 367: {
                this.consumePseudoToken("import", 1, true);
                break;
            }
            case 368: {
                this.consumePseudoToken("package", 1, true);
                break;
            }
            case 369: {
                this.consumePseudoToken("throw", 1, true);
                break;
            }
            case 370: {
                this.consumePseudoToken("new", 1, true);
                break;
            }
            case 371: {
                this.consumePseudoToken("do", 1, true);
                break;
            }
            case 372: {
                this.consumePseudoToken("for", 1, true);
                break;
            }
            case 373: {
                this.consumePseudoToken("switch", 1, true);
                break;
            }
            case 374: {
                this.consumePseudoToken("try", 1, true);
                break;
            }
            case 375: {
                this.consumePseudoToken("while", 1, true);
                break;
            }
            case 376: {
                this.consumePseudoToken("break", 1, true);
                break;
            }
            case 377: {
                this.consumePseudoToken("continue", 1, true);
                break;
            }
            case 378: {
                this.consumePseudoToken("return", 1, true);
                break;
            }
            case 379: {
                this.consumePseudoToken("case", 1, true);
                break;
            }
            case 380: {
                this.consumePseudoToken("catch", 0, true);
                break;
            }
            case 381: {
                this.consumePseudoToken("instanceof", 0, true);
                break;
            }
            case 382: {
                this.consumePseudoToken("else", 0, true);
                break;
            }
            case 383: {
                this.consumePseudoToken("extends", 0, true);
                break;
            }
            case 384: {
                this.consumePseudoToken("finally", 0, true);
                break;
            }
            case 385: {
                this.consumePseudoToken("implements", 0, true);
                break;
            }
            case 386: {
                this.consumePseudoToken("throws", 0, true);
                break;
            }
            case 387: {
                this.consumeClassDeclaration();
                break;
            }
            case 388: {
                this.consumeIntertypeClassDeclaration();
                break;
            }
            case 389: {
                this.consumeIntertypeClassHeader();
                break;
            }
            case 390: {
                this.consumeIntertypeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 392: {
                this.consumeIntertypeClassHeaderName(false);
                break;
            }
            case 393: {
                this.consumeIntertypeClassHeaderName(true);
                break;
            }
            case 394: {
                this.consumeClassHeader();
                break;
            }
            case 395: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 397: {
                this.consumeClassHeaderName1();
                break;
            }
            case 398: {
                this.consumeClassHeaderExtends();
                break;
            }
            case 399: {
                this.consumeClassHeaderImplements();
                break;
            }
            case 401: {
                this.consumeInterfaceTypeList();
                break;
            }
            case 402: {
                this.consumeInterfaceType();
                break;
            }
            case 405: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 409: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 410: {
                this.consumeDiet();
                break;
            }
            case 411: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 412: {
                this.consumeCreateInitializer();
                break;
            }
            case 419: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 422: {
                this.consumeFieldDeclaration();
                break;
            }
            case 424: {
                this.consumeVariableDeclarators();
                break;
            }
            case 427: {
                this.consumeEnterVariable();
                break;
            }
            case 428: {
                this.consumeExitVariableWithInitialization();
                break;
            }
            case 429: {
                this.consumeExitVariableWithoutInitialization();
                break;
            }
            case 430: {
                this.consumeForceNoDiet();
                break;
            }
            case 431: {
                this.consumeRestoreDiet();
                break;
            }
            case 436: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 437: {
                this.consumeMethodDeclaration(true, true);
                break;
            }
            case 438: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 439: {
                this.consumeMethodHeader();
                break;
            }
            case 440: {
                this.consumeMethodHeader();
                break;
            }
            case 441: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 442: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 443: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 444: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 445: {
                this.consumePushCombineModifiers();
                break;
            }
            case 446: {
                this.consumeMethodHeaderRightParen();
                break;
            }
            case 447: {
                this.consumeMethodHeaderExtendedDims();
                break;
            }
            case 448: {
                this.consumeMethodHeaderThrowsClause();
                break;
            }
            case 449: {
                this.consumeConstructorHeader();
                break;
            }
            case 450: {
                this.consumeConstructorHeaderNameWithTypeParameters();
                break;
            }
            case 451: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 452: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 454: {
                this.consumeFormalParameterList();
                break;
            }
            case 455: {
                this.consumeFormalParameter(false);
                break;
            }
            case 456: {
                this.consumeFormalParameter(true);
                break;
            }
            case 457: {
                this.consumeFormalParameter(true);
                break;
            }
            case 458: {
                this.consumeCatchFormalParameter();
                break;
            }
            case 459: {
                this.consumeCatchType();
                break;
            }
            case 460: {
                this.consumeUnionTypeAsClassType();
                break;
            }
            case 461: {
                this.consumeUnionType();
                break;
            }
            case 463: {
                this.consumeClassTypeList();
                break;
            }
            case 464: {
                this.consumeClassTypeElt();
                break;
            }
            case 465: {
                this.consumeMethodBody();
                break;
            }
            case 466: {
                this.consumeNestedMethod();
                break;
            }
            case 467: {
                this.consumeStaticInitializer();
                break;
            }
            case 468: {
                this.consumeStaticOnly();
                break;
            }
            case 469: {
                this.consumeConstructorDeclaration();
                break;
            }
            case 470: {
                this.consumeInvalidConstructorDeclaration();
                break;
            }
            case 471: {
                this.consumeExplicitConstructorInvocation(0, 3);
                break;
            }
            case 472: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 3);
                break;
            }
            case 473: {
                this.consumeExplicitConstructorInvocation(0, 2);
                break;
            }
            case 474: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 2);
                break;
            }
            case 475: {
                this.consumeExplicitConstructorInvocation(1, 2);
                break;
            }
            case 476: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 2);
                break;
            }
            case 477: {
                this.consumeExplicitConstructorInvocation(2, 2);
                break;
            }
            case 478: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 2);
                break;
            }
            case 479: {
                this.consumeExplicitConstructorInvocation(1, 3);
                break;
            }
            case 480: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 3);
                break;
            }
            case 481: {
                this.consumeExplicitConstructorInvocation(2, 3);
                break;
            }
            case 482: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 3);
                break;
            }
            case 483: {
                this.consumeInterfaceDeclaration();
                break;
            }
            case 484: {
                this.consumeInterfaceHeader();
                break;
            }
            case 485: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 487: {
                this.consumeInterfaceHeaderName1();
                break;
            }
            case 488: {
                this.consumeInterfaceHeaderExtends();
                break;
            }
            case 491: {
                this.consumeInterfaceMemberDeclarations();
                break;
            }
            case 492: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 494: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 495: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 496: {
                this.consumeInterfaceMethodDeclaration(true);
                break;
            }
            case 497: {
                this.consumeInvalidConstructorDeclaration(true);
                break;
            }
            case 498: {
                this.consumeInvalidConstructorDeclaration(false);
                break;
            }
            case 509: {
                this.consumePushLeftBrace();
                break;
            }
            case 510: {
                this.consumeEmptyArrayInitializer();
                break;
            }
            case 511: {
                this.consumeArrayInitializer();
                break;
            }
            case 512: {
                this.consumeArrayInitializer();
                break;
            }
            case 514: {
                this.consumeVariableInitializers();
                break;
            }
            case 515: {
                this.consumeBlock();
                break;
            }
            case 516: {
                this.consumeOpenBlock();
                break;
            }
            case 517: {
                this.consumeBlockStatement();
                break;
            }
            case 518: {
                this.consumeBlockStatements();
                break;
            }
            case 525: {
                this.consumeInvalidInterfaceDeclaration();
                break;
            }
            case 526: {
                this.consumeInvalidAnnotationTypeDeclaration();
                break;
            }
            case 527: {
                this.consumeInvalidEnumDeclaration();
                break;
            }
            case 528: {
                this.consumeLocalVariableDeclarationStatement();
                break;
            }
            case 529: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 530: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 531: {
                this.consumePushModifiers();
                break;
            }
            case 532: {
                this.consumePushModifiersForHeader();
                break;
            }
            case 533: {
                this.consumePushRealModifiers();
                break;
            }
            case 560: {
                this.consumeEmptyStatement();
                break;
            }
            case 561: {
                this.consumeStatementLabel();
                break;
            }
            case 562: {
                this.consumeStatementLabel();
                break;
            }
            case 563: {
                this.consumeLabel();
                break;
            }
            case 564: {
                this.consumeExpressionStatement();
                break;
            }
            case 573: {
                this.consumeStatementIfNoElse();
                break;
            }
            case 574: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 575: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 576: {
                this.consumeStatementSwitch();
                break;
            }
            case 577: {
                this.consumeEmptySwitchBlock();
                break;
            }
            case 580: {
                this.consumeSwitchBlock();
                break;
            }
            case 582: {
                this.consumeSwitchBlockStatements();
                break;
            }
            case 584: {
                this.consumeSwitchBlockStatement();
                break;
            }
            case 586: {
                this.consumeSwitchLabels();
                break;
            }
            case 587: {
                this.consumeCaseLabel();
                break;
            }
            case 588: {
                this.consumeDefaultLabel();
                break;
            }
            case 591: {
                this.consumeSwitchExpression();
                break;
            }
            case 594: {
                this.consumeSwitchLabeledRule();
                break;
            }
            case 595: {
                this.consumeSwitchLabeledExpression();
                break;
            }
            case 596: {
                this.consumeSwitchLabeledBlock();
                break;
            }
            case 597: {
                this.consumeSwitchLabeledThrowStatement();
                break;
            }
            case 598: {
                this.consumeDefaultLabelExpr();
                break;
            }
            case 599: {
                this.consumeCaseLabelExpr();
                break;
            }
            case 600: {
                this.consumeSwitchLabelCaseLhs();
                break;
            }
            case 601: {
                this.consumeStatementWhile();
                break;
            }
            case 602: {
                this.consumeStatementWhile();
                break;
            }
            case 603: {
                this.consumeStatementDo();
                break;
            }
            case 604: {
                this.consumeStatementFor();
                break;
            }
            case 605: {
                this.consumeStatementFor();
                break;
            }
            case 606: {
                this.consumeForInit();
                break;
            }
            case 610: {
                this.consumeStatementExpressionList();
                break;
            }
            case 611: {
                this.consumeSimpleAssertStatement();
                break;
            }
            case 612: {
                this.consumeAssertStatement();
                break;
            }
            case 613: {
                this.consumeStatementBreak();
                break;
            }
            case 614: {
                this.consumeStatementBreakWithLabel();
                break;
            }
            case 615: {
                this.consumeStatementContinue();
                break;
            }
            case 616: {
                this.consumeStatementContinueWithLabel();
                break;
            }
            case 617: {
                this.consumeStatementReturn();
                break;
            }
            case 618: {
                this.consumeStatementThrow();
                break;
            }
            case 619: {
                this.consumeThrowExpression();
                break;
            }
            case 620: {
                this.consumeStatementSynchronized();
                break;
            }
            case 621: {
                this.consumeOnlySynchronized();
                break;
            }
            case 622: {
                this.consumeStatementTry(false, false);
                break;
            }
            case 623: {
                this.consumeStatementTry(true, false);
                break;
            }
            case 624: {
                this.consumeStatementTry(false, true);
                break;
            }
            case 625: {
                this.consumeStatementTry(true, true);
                break;
            }
            case 626: {
                this.consumeResourceSpecification();
                break;
            }
            case 627: {
                this.consumeResourceOptionalTrailingSemiColon(false);
                break;
            }
            case 628: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 629: {
                this.consumeSingleResource();
                break;
            }
            case 630: {
                this.consumeMultipleResources();
                break;
            }
            case 631: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 632: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 633: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 634: {
                this.consumeResourceAsLocalVariable();
                break;
            }
            case 635: {
                this.consumeResourceAsFieldAccess();
                break;
            }
            case 637: {
                this.consumeExitTryBlock();
                break;
            }
            case 639: {
                this.consumeCatches();
                break;
            }
            case 640: {
                this.consumeStatementCatch();
                break;
            }
            case 642: {
                this.consumeLeftParen();
                break;
            }
            case 643: {
                this.consumeRightParen();
                break;
            }
            case 648: {
                this.consumePrimaryNoNewArrayThis();
                break;
            }
            case 649: {
                this.consumePrimaryNoNewArray();
                break;
            }
            case 650: {
                this.consumePrimaryNoNewArrayWithName();
                break;
            }
            case 653: {
                this.consumePrimaryNoNewArrayNameThis();
                break;
            }
            case 654: {
                this.consumeQualifiedSuperReceiver();
                break;
            }
            case 655: {
                this.consumePrimaryNoNewArrayName();
                break;
            }
            case 656: {
                this.consumePrimaryNoNewArrayArrayType();
                break;
            }
            case 657: {
                this.consumePrimaryNoNewArrayPrimitiveArrayType();
                break;
            }
            case 658: {
                this.consumePrimaryNoNewArrayPrimitiveType();
                break;
            }
            case 664: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(false);
                break;
            }
            case 665: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(true);
                break;
            }
            case 666: {
                this.consumeReferenceExpressionTypeForm(true);
                break;
            }
            case 667: {
                this.consumeReferenceExpressionTypeForm(false);
                break;
            }
            case 668: {
                this.consumeReferenceExpressionGenericTypeForm();
                break;
            }
            case 669: {
                this.consumeReferenceExpressionPrimaryForm();
                break;
            }
            case 670: {
                this.consumeReferenceExpressionPrimaryForm();
                break;
            }
            case 671: {
                this.consumeReferenceExpressionSuperForm();
                break;
            }
            case 672: {
                this.consumeEmptyTypeArguments();
                break;
            }
            case 674: {
                this.consumeIdentifierOrNew(false);
                break;
            }
            case 675: {
                this.consumeIdentifierOrNew(true);
                break;
            }
            case 676: {
                this.consumeLambdaExpression();
                break;
            }
            case 677: {
                this.consumeNestedLambda();
                break;
            }
            case 678: {
                this.consumeTypeElidedLambdaParameter(false);
                break;
            }
            case 684: {
                this.consumeFormalParameterList();
                break;
            }
            case 685: {
                this.consumeTypeElidedLambdaParameter(true);
                break;
            }
            case 688: {
                this.consumeElidedLeftBraceAndReturn();
                break;
            }
            case 689: {
                this.consumeAllocationHeader();
                break;
            }
            case 690: {
                this.consumeClassInstanceCreationExpressionWithTypeArguments();
                break;
            }
            case 691: {
                this.consumeClassInstanceCreationExpression();
                break;
            }
            case 692: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 693: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 694: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 695: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 696: {
                this.consumeEnterInstanceCreationArgumentList();
                break;
            }
            case 697: {
                this.consumeClassInstanceCreationExpressionName();
                break;
            }
            case 698: {
                this.consumeClassBodyopt();
                break;
            }
            case 700: {
                this.consumeEnterAnonymousClassBody(false);
                break;
            }
            case 701: {
                this.consumeClassBodyopt();
                break;
            }
            case 703: {
                this.consumeEnterAnonymousClassBody(true);
                break;
            }
            case 705: {
                this.consumeArgumentList();
                break;
            }
            case 706: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 707: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 708: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 709: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 710: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 711: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 713: {
                this.consumeDimWithOrWithOutExprs();
                break;
            }
            case 715: {
                this.consumeDimWithOrWithOutExpr();
                break;
            }
            case 716: {
                this.consumeDims();
                break;
            }
            case 719: {
                this.consumeOneDimLoop(false);
                break;
            }
            case 720: {
                this.consumeOneDimLoop(true);
                break;
            }
            case 721: {
                this.consumeFieldAccess(false);
                break;
            }
            case 722: {
                this.consumeFieldAccess(true);
                break;
            }
            case 723: {
                this.consumeFieldAccess(false);
                break;
            }
            case 724: {
                this.consumeMethodInvocationName();
                break;
            }
            case 725: {
                this.consumeMethodInvocationNameWithTypeArguments();
                break;
            }
            case 726: {
                this.consumeMethodInvocationPrimaryWithTypeArguments();
                break;
            }
            case 727: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 728: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 729: {
                this.consumeMethodInvocationPrimaryWithTypeArguments();
                break;
            }
            case 730: {
                this.consumeMethodInvocationSuperWithTypeArguments();
                break;
            }
            case 731: {
                this.consumeMethodInvocationSuper();
                break;
            }
            case 732: {
                this.consumeArrayAccess(true);
                break;
            }
            case 733: {
                this.consumeArrayAccess(true);
                break;
            }
            case 734: {
                this.consumeArrayAccess(false);
                break;
            }
            case 735: {
                this.consumeArrayAccess(false);
                break;
            }
            case 737: {
                this.consumePostfixExpression();
                break;
            }
            case 740: {
                this.consumeUnaryExpression(14, true);
                break;
            }
            case 741: {
                this.consumeUnaryExpression(13, true);
                break;
            }
            case 742: {
                this.consumePushPosition();
                break;
            }
            case 745: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 746: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 748: {
                this.consumeUnaryExpression(14, false);
                break;
            }
            case 749: {
                this.consumeUnaryExpression(13, false);
                break;
            }
            case 751: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 752: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 754: {
                this.consumeCastExpressionWithPrimitiveType();
                break;
            }
            case 755: {
                this.consumeCastExpressionWithGenericsArray();
                break;
            }
            case 756: {
                this.consumeCastExpressionWithQualifiedGenericsArray();
                break;
            }
            case 757: {
                this.consumeCastExpressionLL1();
                break;
            }
            case 758: {
                this.consumeCastExpressionLL1WithBounds();
                break;
            }
            case 759: {
                this.consumeCastExpressionWithNameArray();
                break;
            }
            case 760: {
                this.consumeZeroAdditionalBounds();
                break;
            }
            case 764: {
                this.consumeOnlyTypeArgumentsForCastExpression();
                break;
            }
            case 765: {
                this.consumeInsideCastExpression();
                break;
            }
            case 766: {
                this.consumeInsideCastExpressionLL1();
                break;
            }
            case 767: {
                this.consumeInsideCastExpressionLL1WithBounds();
                break;
            }
            case 768: {
                this.consumeInsideCastExpressionWithQualifiedGenerics();
                break;
            }
            case 770: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 771: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 772: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 774: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 775: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 777: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 778: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 779: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 781: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 782: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 783: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 784: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 786: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 788: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 789: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 791: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 793: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 795: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 797: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 799: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 801: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 804: {
                this.consumeAssignment();
                break;
            }
            case 806: {
                this.ignoreExpressionAssignment();
                break;
            }
            case 807: {
                this.consumeAssignmentOperator(30);
                break;
            }
            case 808: {
                this.consumeAssignmentOperator(15);
                break;
            }
            case 809: {
                this.consumeAssignmentOperator(9);
                break;
            }
            case 810: {
                this.consumeAssignmentOperator(16);
                break;
            }
            case 811: {
                this.consumeAssignmentOperator(14);
                break;
            }
            case 812: {
                this.consumeAssignmentOperator(13);
                break;
            }
            case 813: {
                this.consumeAssignmentOperator(10);
                break;
            }
            case 814: {
                this.consumeAssignmentOperator(17);
                break;
            }
            case 815: {
                this.consumeAssignmentOperator(19);
                break;
            }
            case 816: {
                this.consumeAssignmentOperator(2);
                break;
            }
            case 817: {
                this.consumeAssignmentOperator(8);
                break;
            }
            case 818: {
                this.consumeAssignmentOperator(3);
                break;
            }
            case 819: {
                this.consumeExpression();
                break;
            }
            case 822: {
                this.consumeEmptyExpression();
                break;
            }
            case 825: {
                this.consumeConstantExpressions();
                break;
            }
            case 829: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 830: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 831: {
                this.consumeDefaultModifiers();
                break;
            }
            case 832: {
                this.consumeModifiers();
                break;
            }
            case 833: {
                this.consumeEmptyBlockStatementsopt();
                break;
            }
            case 835: {
                this.consumeEmptyDimsopt();
                break;
            }
            case 837: {
                this.consumeEmptyArgumentListopt();
                break;
            }
            case 841: {
                this.consumeFormalParameterListopt();
                break;
            }
            case 845: {
                this.consumeEmptyInterfaceMemberDeclarationsopt();
                break;
            }
            case 846: {
                this.consumeInterfaceMemberDeclarationsopt();
                break;
            }
            case 847: {
                this.consumeNestedType();
                break;
            }
            case 848: {
                this.consumeEmptyForInitopt();
                break;
            }
            case 850: {
                this.consumeEmptyForUpdateopt();
                break;
            }
            case 854: {
                this.consumeEmptyCatchesopt();
                break;
            }
            case 856: {
                this.consumeEnumDeclaration();
                break;
            }
            case 857: {
                this.consumeEnumHeader();
                break;
            }
            case 858: {
                this.consumeEnumHeaderName();
                break;
            }
            case 859: {
                this.consumeEnumHeaderNameWithTypeParameters();
                break;
            }
            case 860: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 861: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 862: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 863: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 865: {
                this.consumeEnumConstants();
                break;
            }
            case 866: {
                this.consumeEnumConstantHeaderName();
                break;
            }
            case 867: {
                this.consumeEnumConstantHeader();
                break;
            }
            case 868: {
                this.consumeEnumConstantWithClassBody();
                break;
            }
            case 869: {
                this.consumeEnumConstantNoClassBody();
                break;
            }
            case 870: {
                this.consumeArguments();
                break;
            }
            case 871: {
                this.consumeEmptyArguments();
                break;
            }
            case 873: {
                this.consumeEnumDeclarations();
                break;
            }
            case 874: {
                this.consumeEmptyEnumDeclarations();
                break;
            }
            case 876: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 877: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 878: {
                this.consumeEnhancedForStatementHeaderInit(false);
                break;
            }
            case 879: {
                this.consumeEnhancedForStatementHeaderInit(true);
                break;
            }
            case 880: {
                this.consumeEnhancedForStatementHeader();
                break;
            }
            case 881: {
                this.consumeImportDeclaration();
                break;
            }
            case 882: {
                this.consumeSingleStaticImportDeclarationName();
                break;
            }
            case 883: {
                this.consumeImportDeclaration();
                break;
            }
            case 884: {
                this.consumeStaticImportOnDemandDeclarationName();
                break;
            }
            case 885: {
                this.consumeTypeArguments();
                break;
            }
            case 886: {
                this.consumeOnlyTypeArguments();
                break;
            }
            case 888: {
                this.consumeTypeArgumentList1();
                break;
            }
            case 890: {
                this.consumeTypeArgumentList();
                break;
            }
            case 891: {
                this.consumeTypeArgument();
                break;
            }
            case 895: {
                this.consumeReferenceType1();
                break;
            }
            case 896: {
                this.consumeTypeArgumentReferenceType1();
                break;
            }
            case 898: {
                this.consumeTypeArgumentList2();
                break;
            }
            case 901: {
                this.consumeReferenceType2();
                break;
            }
            case 902: {
                this.consumeTypeArgumentReferenceType2();
                break;
            }
            case 904: {
                this.consumeTypeArgumentList3();
                break;
            }
            case 907: {
                this.consumeReferenceType3();
                break;
            }
            case 908: {
                this.consumeWildcard();
                break;
            }
            case 909: {
                this.consumeWildcardWithBounds();
                break;
            }
            case 910: {
                this.consumeWildcardBoundsExtends();
                break;
            }
            case 911: {
                this.consumeWildcardBoundsSuper();
                break;
            }
            case 912: {
                this.consumeWildcard1();
                break;
            }
            case 913: {
                this.consumeWildcard1WithBounds();
                break;
            }
            case 914: {
                this.consumeWildcardBounds1Extends();
                break;
            }
            case 915: {
                this.consumeWildcardBounds1Super();
                break;
            }
            case 916: {
                this.consumeWildcard2();
                break;
            }
            case 917: {
                this.consumeWildcard2WithBounds();
                break;
            }
            case 918: {
                this.consumeWildcardBounds2Extends();
                break;
            }
            case 919: {
                this.consumeWildcardBounds2Super();
                break;
            }
            case 920: {
                this.consumeWildcard3();
                break;
            }
            case 921: {
                this.consumeWildcard3WithBounds();
                break;
            }
            case 922: {
                this.consumeWildcardBounds3Extends();
                break;
            }
            case 923: {
                this.consumeWildcardBounds3Super();
                break;
            }
            case 924: {
                this.consumeTypeParameterHeader();
                break;
            }
            case 925: {
                this.consumeTypeParameters();
                break;
            }
            case 927: {
                this.consumeTypeParameterList();
                break;
            }
            case 929: {
                this.consumeTypeParameterWithExtends();
                break;
            }
            case 930: {
                this.consumeTypeParameterWithExtendsAndBounds();
                break;
            }
            case 932: {
                this.consumeAdditionalBoundList();
                break;
            }
            case 933: {
                this.consumeAdditionalBound();
                break;
            }
            case 935: {
                this.consumeTypeParameterList1();
                break;
            }
            case 936: {
                this.consumeTypeParameter1();
                break;
            }
            case 937: {
                this.consumeTypeParameter1WithExtends();
                break;
            }
            case 938: {
                this.consumeTypeParameter1WithExtendsAndBounds();
                break;
            }
            case 940: {
                this.consumeAdditionalBoundList1();
                break;
            }
            case 941: {
                this.consumeAdditionalBound1();
                break;
            }
            case 947: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 948: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 951: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 952: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 955: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 956: {
                this.consumeBinaryExpressionWithName(15);
                break;
            }
            case 957: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 958: {
                this.consumeBinaryExpressionWithName(9);
                break;
            }
            case 959: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 960: {
                this.consumeBinaryExpressionWithName(16);
                break;
            }
            case 962: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 963: {
                this.consumeBinaryExpressionWithName(14);
                break;
            }
            case 964: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 965: {
                this.consumeBinaryExpressionWithName(13);
                break;
            }
            case 967: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 968: {
                this.consumeBinaryExpressionWithName(10);
                break;
            }
            case 969: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 970: {
                this.consumeBinaryExpressionWithName(17);
                break;
            }
            case 971: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 972: {
                this.consumeBinaryExpressionWithName(19);
                break;
            }
            case 974: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 975: {
                this.consumeBinaryExpressionWithName(4);
                break;
            }
            case 976: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 977: {
                this.consumeBinaryExpressionWithName(6);
                break;
            }
            case 978: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 979: {
                this.consumeBinaryExpressionWithName(5);
                break;
            }
            case 980: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 981: {
                this.consumeBinaryExpressionWithName(7);
                break;
            }
            case 983: {
                this.consumeInstanceOfExpressionWithName();
                break;
            }
            case 984: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 986: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 987: {
                this.consumeEqualityExpressionWithName(18);
                break;
            }
            case 988: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 989: {
                this.consumeEqualityExpressionWithName(29);
                break;
            }
            case 991: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 992: {
                this.consumeBinaryExpressionWithName(2);
                break;
            }
            case 994: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 995: {
                this.consumeBinaryExpressionWithName(8);
                break;
            }
            case 997: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 998: {
                this.consumeBinaryExpressionWithName(3);
                break;
            }
            case 1000: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 1001: {
                this.consumeBinaryExpressionWithName(0);
                break;
            }
            case 1003: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 1004: {
                this.consumeBinaryExpressionWithName(1);
                break;
            }
            case 1006: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 1007: {
                this.consumeConditionalExpressionWithName(23);
                break;
            }
            case 1011: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 1012: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 1013: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 1014: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 1015: {
                this.consumeAnnotationTypeDeclarationHeader();
                break;
            }
            case 1016: {
                this.consumeAnnotationTypeDeclaration();
                break;
            }
            case 1018: {
                this.consumeEmptyAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 1019: {
                this.consumeAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 1021: {
                this.consumeAnnotationTypeMemberDeclarations();
                break;
            }
            case 1022: {
                this.consumeMethodHeaderNameWithTypeParameters(true);
                break;
            }
            case 1023: {
                this.consumeMethodHeaderName(true);
                break;
            }
            case 1024: {
                this.consumeEmptyMethodHeaderDefaultValue();
                break;
            }
            case 1025: {
                this.consumeMethodHeaderDefaultValue();
                break;
            }
            case 1026: {
                this.consumeMethodHeader();
                break;
            }
            case 1027: {
                this.consumeAnnotationTypeMemberDeclaration();
                break;
            }
            case 1035: {
                this.consumeAnnotationName();
                break;
            }
            case 1036: {
                this.consumeNormalAnnotation(false);
                break;
            }
            case 1037: {
                this.consumeEmptyMemberValuePairsopt();
                break;
            }
            case 1040: {
                this.consumeMemberValuePairs();
                break;
            }
            case 1041: {
                this.consumeMemberValuePair();
                break;
            }
            case 1042: {
                this.consumeEnterMemberValue();
                break;
            }
            case 1043: {
                this.consumeExitMemberValue();
                break;
            }
            case 1045: {
                this.consumeMemberValueAsName();
                break;
            }
            case 1048: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 1049: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 1050: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 1051: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 1052: {
                this.consumeEnterMemberValueArrayInitializer();
                break;
            }
            case 1054: {
                this.consumeMemberValues();
                break;
            }
            case 1055: {
                this.consumeMarkerAnnotation(false);
                break;
            }
            case 1056: {
                this.consumeSingleMemberAnnotationMemberValue();
                break;
            }
            case 1057: {
                this.consumeSingleMemberAnnotation(false);
                break;
            }
            case 1058: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 1059: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 1060: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 1061: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 1062: {
                this.consumeMethodHeader();
                break;
            }
            case 1063: {
                this.consumeMethodHeader();
            }
        }
    }

    protected void consumeQualifiedName() {
        this.consumeQualifiedName(false);
    }

    private void consumeIntertypeClassHeader() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        if (this.currentToken == 65) {
            typeDecl.bodyStart = this.scanner.currentPosition;
        }
        if (this.currentElement != null) {
            this.restartRecovery = true;
        }
        this.scanner.commentPtr = -1;
    }

    private void consumeIntertypeClassDeclaration() {
        TypeDeclaration typeDecl;
        boolean hasConstructor;
        int length;
        if ((length = this.astLengthStack[this.astLengthPtr--]) != 0) {
            this.dispatchDeclarationInto(length);
        }
        if (!(hasConstructor = (typeDecl = (TypeDeclaration)this.astStack[this.astPtr]).checkConstructors(this))) {
            switch (TypeDeclaration.kind(typeDecl.modifiers)) {
                case 1: 
                case 3: {
                    boolean insideFieldInitializer = false;
                    if (this.diet) {
                        int i = this.nestedType;
                        while (i > 0) {
                            if (this.variablesCounter[i] > 0) {
                                insideFieldInitializer = true;
                                break;
                            }
                            --i;
                        }
                    }
                    typeDecl.createDefaultConstructor(!this.diet || insideFieldInitializer, true);
                }
            }
        }
        if (this.scanner.containsAssertKeyword) {
            typeDecl.bits |= 1;
        }
        typeDecl.addClinit();
        typeDecl.bodyEnd = this.endStatementPosition;
        if (length == 0 && !this.containsComment(typeDecl.bodyStart, typeDecl.bodyEnd)) {
            typeDecl.bits |= 8;
        }
        typeDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    private void consumeIntertypeTypeHeaderNameWithTypeParameters() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            RecoveredType recoveredType = (RecoveredType)this.currentElement;
            recoveredType.pendingTypeParameters = null;
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private void consumeIntertypeClassHeaderName(boolean b) {
        int length;
        TypeDeclaration typeDecl = declarationFactory.createIntertypeMemberClassDeclaration(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                typeDecl.bits |= 0x400;
            }
        } else {
            typeDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        typeDecl.sourceEnd = (int)pos;
        typeDecl.sourceStart = (int)(pos >>> 32);
        typeDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (b) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(typeDecl, onType);
        typeDecl.declarationSourceStart = this.intStack[this.intPtr--];
        --this.intPtr;
        typeDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        typeDecl.modifiers = this.intStack[this.intPtr--];
        if (typeDecl.modifiersSourceStart >= 0) {
            typeDecl.declarationSourceStart = typeDecl.modifiersSourceStart;
        }
        if ((typeDecl.bits & 0x400) == 0 && (typeDecl.bits & 0x100) == 0 && this.compilationUnit != null && !CharOperation.equals(typeDecl.name, this.compilationUnit.getMainTypeName())) {
            typeDecl.bits |= 0x1000;
        }
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            typeDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, typeDecl.annotations, 0, length);
        }
        typeDecl.bodyStart = typeDecl.sourceEnd + 1;
        this.pushOnAstStack(typeDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
            this.currentElement = this.currentElement.add(typeDecl, 0);
            this.lastIgnoredToken = -1;
        }
        typeDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected ASTNode popPointcutDesignator(String terminator) {
        ASTNode tokens = this.popPseudoTokens(terminator);
        return declarationFactory.createPointcutDesignator(this, tokens);
    }

    protected ASTNode popPseudoTokens(String terminator) {
        this.consumePseudoToken(terminator);
        this.consumePseudoTokens();
        int length = this.astLengthStack[this.astLengthPtr--];
        this.astPtr -= length;
        ASTNode[] tokens = new ASTNode[length];
        System.arraycopy(this.astStack, this.astPtr + 1, tokens, 0, length);
        this.listLength = 0;
        return declarationFactory.createPseudoTokensFrom(tokens, this.compilationUnit.compilationResult());
    }

    private void swapAstStack() {
        ASTNode next;
        ASTNode top = this.astStack[this.astPtr];
        this.astStack[this.astPtr] = next = this.astStack[this.astPtr - 1];
        this.astStack[this.astPtr - 1] = top;
    }

    private void consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern(String badToken) {
        this.consumeInterTypeFieldHeader(false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 14, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeConstructorHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 14, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeMethodHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 14, badToken.toCharArray(), badToken);
    }

    private void consumeAroundHeaderNameMissingReturnType() {
        this.problemReporter().parseErrorInsertToComplete(this.scanner.startPosition, this.scanner.currentPosition, "return type", "around advice declaration");
        this.restartRecovery = true;
    }

    private void consumeBadHeader() {
        this.problemReporter().parseErrorReplaceTokens(this.scanner.startPosition, this.scanner.currentPosition, "valid member declaration");
        this.restartRecovery = true;
    }

    @Override
    protected void consumeSimpleAssertStatement() {
        super.consumeSimpleAssertStatement();
    }

    private void convertTypeParametersToSingleTypeReferences() {
        int typeParameterIndex = 0;
        while (typeParameterIndex < this.genericsLengthStack[this.genericsLengthPtr]) {
            TypeParameter tp = (TypeParameter)this.genericsStack[this.genericsPtr - typeParameterIndex];
            SingleTypeReference str = new SingleTypeReference(tp.name, tp.declarationSourceStart);
            this.genericsStack[this.genericsPtr - typeParameterIndex] = str;
            ++typeParameterIndex;
        }
    }

    public Parser() {
    }

    public Parser(ProblemReporter problemReporter, boolean optimizeStringLiterals) {
        super(problemReporter, optimizeStringLiterals);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean shouldTryToRecover() {
        ASTNode aSTNode;
        int index = 0;
        while (index < this.astStack.length && (aSTNode = this.astStack[index++]) != null) {
            void node;
            if (declarationFactory.shouldTryToRecover((ASTNode)node)) continue;
            return false;
        }
        return true;
    }

    protected void pushOnAspectIntStack(int pos) {
        int stackLength = this.aspectIntStack.length;
        if (++this.aspectIntPtr >= stackLength) {
            this.aspectIntStack = new int[stackLength + 255];
            System.arraycopy(this.aspectIntStack, 0, this.aspectIntStack, 0, stackLength);
        }
        this.aspectIntStack[this.aspectIntPtr] = pos;
    }

    public static interface IDeclarationFactory {
        public MessageSend createProceed(MessageSend var1);

        public TypeDeclaration createAspect(CompilationResult var1);

        public void setPrivileged(TypeDeclaration var1, boolean var2);

        public void setPerClauseFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public void setDominatesPatternFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public ASTNode createPseudoTokensFrom(ASTNode[] var1, CompilationResult var2);

        public MethodDeclaration createMethodDeclaration(CompilationResult var1);

        public ConstructorDeclaration createConstructorDeclaration(CompilationResult var1);

        public MethodDeclaration createPointcutDeclaration(CompilationResult var1);

        public MethodDeclaration createAroundAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createAfterAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createBeforeAdviceDeclaration(CompilationResult var1);

        public ASTNode createPointcutDesignator(Parser var1, ASTNode var2);

        public void setPointcutDesignatorOnAdvice(MethodDeclaration var1, ASTNode var2);

        public void setPointcutDesignatorOnPointcut(MethodDeclaration var1, ASTNode var2);

        public void setExtraArgument(MethodDeclaration var1, Argument var2);

        public boolean isAfterAdvice(MethodDeclaration var1);

        public void setAfterThrowingAdviceKind(MethodDeclaration var1);

        public void setAfterReturningAdviceKind(MethodDeclaration var1);

        public MethodDeclaration createDeclareDeclaration(CompilationResult var1, ASTNode var2, Parser var3);

        public MethodDeclaration createDeclareAnnotationDeclaration(CompilationResult var1, ASTNode var2, Annotation var3, Parser var4, char var5);

        public MethodDeclaration createInterTypeFieldDeclaration(CompilationResult var1, TypeReference var2);

        public MethodDeclaration createInterTypeMethodDeclaration(CompilationResult var1);

        public MethodDeclaration createInterTypeConstructorDeclaration(CompilationResult var1);

        public void setSelector(MethodDeclaration var1, char[] var2);

        public void setDeclaredModifiers(MethodDeclaration var1, int var2);

        public void setInitialization(MethodDeclaration var1, Expression var2);

        public void setOnType(MethodDeclaration var1, TypeReference var2);

        public ASTNode createPseudoToken(Parser var1, String var2, boolean var3);

        public ASTNode createIfPseudoToken(Parser var1, Expression var2);

        public void setLiteralKind(ASTNode var1, String var2);

        public boolean shouldTryToRecover(ASTNode var1);

        public TypeDeclaration createIntertypeMemberClassDeclaration(CompilationResult var1);

        public void setOnType(TypeDeclaration var1, TypeReference var2);
    }
}

