/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.data.Index;
import org.assertj.core.internal.BooleanArrays;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractBooleanArrayAssert<S extends AbstractBooleanArrayAssert<S>>
extends AbstractAssert<S, boolean[]>
implements EnumerableAssert<AbstractBooleanArrayAssert<S>, Boolean>,
ArraySortedAssert<AbstractBooleanArrayAssert<S>, Boolean> {
    @VisibleForTesting
    protected BooleanArrays arrays = BooleanArrays.instance();

    public AbstractBooleanArrayAssert(boolean[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (boolean[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (boolean[])this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (boolean[])this.actual);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (boolean[])this.actual, expected);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object[] other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (boolean[])this.actual, other);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (boolean[])this.actual, other);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    public S contains(boolean ... values) {
        this.arrays.assertContains(this.info, (boolean[])this.actual, values);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    public S containsOnly(boolean ... values) {
        this.arrays.assertContainsOnly(this.info, (boolean[])this.actual, values);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    public S containsOnlyOnce(boolean ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (boolean[])this.actual, values);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    public S containsSequence(boolean ... sequence) {
        this.arrays.assertContainsSequence(this.info, (boolean[])this.actual, sequence);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    public S containsSubsequence(boolean ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (boolean[])this.actual, subsequence);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    public S contains(boolean value, Index index) {
        this.arrays.assertContains(this.info, (boolean[])this.actual, value, index);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    public S doesNotContain(boolean ... values) {
        this.arrays.assertDoesNotContain(this.info, (boolean[])this.actual, values);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    public S doesNotContain(boolean value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (boolean[])this.actual, value, index);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    public S doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (boolean[])this.actual);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    public S startsWith(boolean ... sequence) {
        this.arrays.assertStartsWith(this.info, (boolean[])this.actual, sequence);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    public S endsWith(boolean ... sequence) {
        this.arrays.assertEndsWith(this.info, (boolean[])this.actual, sequence);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public S isSorted() {
        this.arrays.assertIsSorted(this.info, (boolean[])this.actual);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    public S isSortedAccordingTo(Comparator<? super Boolean> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (boolean[])this.actual, comparator);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }

    @Override
    @Deprecated
    public final S usingElementComparator(Comparator<? super Boolean> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for Boolean array comparison");
    }

    @Override
    @Deprecated
    public final S usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for Boolean array comparison");
    }

    public S containsExactly(boolean ... values) {
        this.objects.assertEqual(this.info, this.actual, values);
        return (S)((AbstractBooleanArrayAssert)this.myself);
    }
}

