/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.data.Index;
import org.assertj.core.internal.CharArrays;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractCharArrayAssert<S extends AbstractCharArrayAssert<S>>
extends AbstractAssert<S, char[]>
implements EnumerableAssert<AbstractCharArrayAssert<S>, Character>,
ArraySortedAssert<AbstractCharArrayAssert<S>, Character> {
    @VisibleForTesting
    protected CharArrays arrays = CharArrays.instance();

    public AbstractCharArrayAssert(char[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (char[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (char[])this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (char[])this.actual);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (char[])this.actual, expected);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object[] other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (char[])this.actual, other);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (char[])this.actual, other);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S contains(char ... values) {
        this.arrays.assertContains(this.info, (char[])this.actual, values);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S containsOnly(char ... values) {
        this.arrays.assertContainsOnly(this.info, (char[])this.actual, values);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S containsOnlyOnce(char ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (char[])this.actual, values);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S containsSequence(char ... sequence) {
        this.arrays.assertContainsSequence(this.info, (char[])this.actual, sequence);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S containsSubsequence(char ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (char[])this.actual, subsequence);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S contains(char value, Index index) {
        this.arrays.assertContains(this.info, (char[])this.actual, value, index);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S doesNotContain(char ... values) {
        this.arrays.assertDoesNotContain(this.info, (char[])this.actual, values);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S doesNotContain(char value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (char[])this.actual, value, index);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (char[])this.actual);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S startsWith(char ... sequence) {
        this.arrays.assertStartsWith(this.info, (char[])this.actual, sequence);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S endsWith(char ... sequence) {
        this.arrays.assertEndsWith(this.info, (char[])this.actual, sequence);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    public S isSorted() {
        this.arrays.assertIsSorted(this.info, (char[])this.actual);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    public S isSortedAccordingTo(Comparator<? super Character> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (char[])this.actual, comparator);
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super Character> customComparator) {
        this.arrays = new CharArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.arrays = CharArrays.instance();
        return (S)((AbstractCharArrayAssert)this.myself);
    }

    public S containsExactly(char ... values) {
        this.objects.assertEqual(this.info, this.actual, values);
        return (S)((AbstractCharArrayAssert)this.myself);
    }
}

