/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Dates;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractDateAssert<S extends AbstractDateAssert<S>>
extends AbstractAssert<S, Date> {
    @VisibleForTesting
    Dates dates = Dates.instance();
    @VisibleForTesting
    static DateFormat dateFormat = org.assertj.core.util.Dates.newIsoDateFormat();

    protected AbstractDateAssert(Date actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isEqualTo(String dateAsString) {
        return (S)((AbstractDateAssert)this.isEqualTo(AbstractDateAssert.parse(dateAsString)));
    }

    public S isNotEqualTo(String dateAsString) {
        return (S)((AbstractDateAssert)this.isNotEqualTo(AbstractDateAssert.parse(dateAsString)));
    }

    public S isIn(String ... datesAsString) {
        Date[] dates = new Date[datesAsString.length];
        for (int i = 0; i < datesAsString.length; ++i) {
            dates[i] = AbstractDateAssert.parse(datesAsString[i]);
        }
        return (S)((AbstractDateAssert)this.isIn(dates));
    }

    public S isInWithStringDateCollection(Collection<String> datesAsString) {
        ArrayList<Date> dates = new ArrayList<Date>(datesAsString.size());
        for (String dateAsString : datesAsString) {
            dates.add(AbstractDateAssert.parse(dateAsString));
        }
        return (S)((AbstractDateAssert)this.isIn(dates));
    }

    public S isNotIn(String ... datesAsString) {
        Date[] dates = new Date[datesAsString.length];
        for (int i = 0; i < datesAsString.length; ++i) {
            dates[i] = AbstractDateAssert.parse(datesAsString[i]);
        }
        return (S)((AbstractDateAssert)this.isNotIn(dates));
    }

    public S isNotInWithStringDateCollection(Collection<String> datesAsString) {
        ArrayList<Date> dates = new ArrayList<Date>(datesAsString.size());
        for (String dateAsString : datesAsString) {
            dates.add(AbstractDateAssert.parse(dateAsString));
        }
        return (S)((AbstractDateAssert)this.isNotIn(dates));
    }

    public S isBefore(Date other) {
        this.dates.assertIsBefore(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isBefore(String dateAsString) {
        return this.isBefore(AbstractDateAssert.parse(dateAsString));
    }

    public S isBeforeOrEqualsTo(Date other) {
        this.dates.assertIsBeforeOrEqualsTo(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isBeforeOrEqualsTo(String dateAsString) {
        return this.isBeforeOrEqualsTo(AbstractDateAssert.parse(dateAsString));
    }

    public S isAfter(Date other) {
        this.dates.assertIsAfter(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isAfter(String dateAsString) {
        return this.isAfter(AbstractDateAssert.parse(dateAsString));
    }

    public S isAfterOrEqualsTo(Date other) {
        this.dates.assertIsAfterOrEqualsTo(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isAfterOrEqualsTo(String dateAsString) {
        return this.isAfterOrEqualsTo(AbstractDateAssert.parse(dateAsString));
    }

    public S isBetween(Date start, Date end) {
        return this.isBetween(start, end, true, false);
    }

    public S isBetween(String start, String end) {
        return this.isBetween(AbstractDateAssert.parse(start), AbstractDateAssert.parse(end));
    }

    public S isBetween(Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsBetween(this.info, (Date)this.actual, start, end, inclusiveStart, inclusiveEnd);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isBetween(String start, String end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsBetween(this.info, (Date)this.actual, AbstractDateAssert.parse(start), AbstractDateAssert.parse(end), inclusiveStart, inclusiveEnd);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isNotBetween(Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsNotBetween(this.info, (Date)this.actual, start, end, inclusiveStart, inclusiveEnd);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isNotBetween(String start, String end, boolean inclusiveStart, boolean inclusiveEnd) {
        return this.isNotBetween(AbstractDateAssert.parse(start), AbstractDateAssert.parse(end), inclusiveStart, inclusiveEnd);
    }

    public S isNotBetween(Date start, Date end) {
        return this.isNotBetween(start, end, true, false);
    }

    public S isNotBetween(String start, String end) {
        return this.isNotBetween(AbstractDateAssert.parse(start), AbstractDateAssert.parse(end), true, false);
    }

    public S isInThePast() {
        this.dates.assertIsInThePast(this.info, (Date)this.actual);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isToday() {
        this.dates.assertIsToday(this.info, (Date)this.actual);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInTheFuture() {
        this.dates.assertIsInTheFuture(this.info, (Date)this.actual);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isBeforeYear(int year) {
        this.dates.assertIsBeforeYear(this.info, (Date)this.actual, year);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isAfterYear(int year) {
        this.dates.assertIsAfterYear(this.info, (Date)this.actual, year);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinYear(int year) {
        this.dates.assertIsWithinYear(this.info, (Date)this.actual, year);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinMonth(int month) {
        this.dates.assertIsWithinMonth(this.info, (Date)this.actual, month);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinDayOfMonth(int dayOfMonth) {
        this.dates.assertIsWithinDayOfMonth(this.info, (Date)this.actual, dayOfMonth);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinDayOfWeek(int dayOfWeek) {
        this.dates.assertIsWithinDayOfWeek(this.info, (Date)this.actual, dayOfWeek);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinHourOfDay(int hourOfDay) {
        this.dates.assertIsWithinHourOfDay(this.info, (Date)this.actual, hourOfDay);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinMinute(int minute) {
        this.dates.assertIsWithinMinute(this.info, (Date)this.actual, minute);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinSecond(int second) {
        this.dates.assertIsWithinSecond(this.info, (Date)this.actual, second);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinMillisecond(int millisecond) {
        this.dates.assertIsWithinMillisecond(this.info, (Date)this.actual, millisecond);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameYearAs(Date other) {
        this.dates.assertIsInSameYearAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameYearAs(String dateAsString) {
        return this.isInSameYearAs(AbstractDateAssert.parse(dateAsString));
    }

    public S isInSameMonthAs(Date other) {
        this.dates.assertIsInSameMonthAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameMonthAs(String dateAsString) {
        return this.isInSameMonthAs(AbstractDateAssert.parse(dateAsString));
    }

    public S isInSameDayAs(Date other) {
        this.dates.assertIsInSameDayAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameDayAs(String dateAsString) {
        return this.isInSameDayAs(AbstractDateAssert.parse(dateAsString));
    }

    public S isInSameHourAs(Date other) {
        this.dates.assertIsInSameHourAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameHourAs(String dateAsString) {
        return this.isInSameHourAs(AbstractDateAssert.parse(dateAsString));
    }

    public S isInSameMinuteAs(Date other) {
        this.dates.assertIsInSameMinuteAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameMinuteAs(String dateAsString) {
        return this.isInSameMinuteAs(AbstractDateAssert.parse(dateAsString));
    }

    public S isInSameSecondAs(Date other) {
        this.dates.assertIsInSameSecondAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameSecondAs(String dateAsString) {
        return this.isInSameSecondAs(AbstractDateAssert.parse(dateAsString));
    }

    public S isCloseTo(Date other, long deltaInMilliseconds) {
        this.dates.assertIsCloseTo(this.info, (Date)this.actual, other, deltaInMilliseconds);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isCloseTo(String dateAsString, long deltaInMilliseconds) {
        return this.isCloseTo(AbstractDateAssert.parse(dateAsString), deltaInMilliseconds);
    }

    public S hasTime(long timestamp) {
        this.dates.assertHasTime(this.info, (Date)this.actual, timestamp);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S withDateFormat(DateFormat userCustomDateFormat) {
        AbstractDateAssert.useDateFormat(userCustomDateFormat);
        return (S)((AbstractDateAssert)this.myself);
    }

    public static void useDateFormat(DateFormat userCustomDateFormat) {
        if (userCustomDateFormat == null) {
            throw new NullPointerException("The given date format should not be null");
        }
        dateFormat = userCustomDateFormat;
    }

    public S withIsoDateFormat() {
        AbstractDateAssert.useIsoDateFormat();
        return (S)((AbstractDateAssert)this.myself);
    }

    public static void useIsoDateFormat() {
        dateFormat = org.assertj.core.util.Dates.newIsoDateFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parse(String dateAsString) {
        if (dateAsString == null) {
            return null;
        }
        try {
            DateFormat dateFormat = AbstractDateAssert.dateFormat;
            synchronized (dateFormat) {
                return AbstractDateAssert.dateFormat.parse(dateAsString);
            }
        }
        catch (ParseException e) {
            throw Failures.instance().failure("Failed to parse " + dateAsString + " with date format " + dateFormat);
        }
    }

    @Override
    public S usingComparator(Comparator<? super Date> customComparator) {
        super.usingComparator(customComparator);
        this.dates = new Dates(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractDateAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.dates = Dates.instance();
        return (S)((AbstractDateAssert)this.myself);
    }
}

