/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.data.Index;
import org.assertj.core.error.ConditionAndGroupGenericParameterTypeShouldBeTheSame;
import org.assertj.core.error.ElementsShouldBe;
import org.assertj.core.error.ElementsShouldBeAtLeast;
import org.assertj.core.error.ElementsShouldBeAtMost;
import org.assertj.core.error.ElementsShouldBeExactly;
import org.assertj.core.error.ElementsShouldHave;
import org.assertj.core.error.ElementsShouldHaveAtLeast;
import org.assertj.core.error.ElementsShouldHaveAtMost;
import org.assertj.core.error.ElementsShouldHaveExactly;
import org.assertj.core.error.ElementsShouldNotBe;
import org.assertj.core.error.ElementsShouldNotHave;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldBeSorted;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainAtIndex;
import org.assertj.core.error.ShouldContainNull;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldContainSequence;
import org.assertj.core.error.ShouldContainSubsequence;
import org.assertj.core.error.ShouldContainsOnlyOnce;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotContainAtIndex;
import org.assertj.core.error.ShouldNotContainNull;
import org.assertj.core.error.ShouldNotHaveDuplicates;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.ArrayWrapperList;
import org.assertj.core.util.Iterables;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;

class Arrays {
    private static final Arrays INSTANCE = new Arrays();
    private final ComparisonStrategy comparisonStrategy;

    static Arrays instance() {
        return INSTANCE;
    }

    private Arrays() {
        this(StandardComparisonStrategy.instance());
    }

    public Arrays(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    void assertNullOrEmpty(AssertionInfo info, Failures failures, Object array) {
        if (array == null || Arrays.isArrayEmpty(array)) {
            return;
        }
        throw failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(array));
    }

    void assertEmpty(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        if (Arrays.isArrayEmpty(array)) {
            return;
        }
        throw failures.failure(info, ShouldBeEmpty.shouldBeEmpty(array));
    }

    void assertHasSize(AssertionInfo info, Failures failures, Object array, int expectedSize) {
        Arrays.assertNotNull(info, array);
        int sizeOfActual = Arrays.sizeOf(array);
        if (sizeOfActual == expectedSize) {
            return;
        }
        throw failures.failure(info, ShouldHaveSize.shouldHaveSize(array, sizeOfActual, expectedSize));
    }

    void assertHasSameSizeAs(AssertionInfo info, Object array, Iterable<?> other) {
        Arrays.assertNotNull(info, array);
        CommonValidations.hasSameSizeAsCheck(info, array, other, Arrays.sizeOf(array));
    }

    void assertHasSameSizeAs(AssertionInfo info, Object array, Object other) {
        Arrays.assertNotNull(info, array);
        CommonValidations.hasSameSizeAsCheck(info, array, other, Arrays.sizeOf(array));
    }

    void assertContains(AssertionInfo info, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info, actual, values)) {
            return;
        }
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        int valueCount = Arrays.sizeOf(values);
        for (int i = 0; i < valueCount; ++i) {
            Object value = Array.get(values, i);
            if (this.arrayContains(actual, value)) continue;
            notFound.add(value);
        }
        if (!notFound.isEmpty()) {
            throw failures.failure(info, ShouldContain.shouldContain(actual, values, notFound, this.comparisonStrategy));
        }
    }

    void assertcontainsAll(AssertionInfo info, Failures failures, Object array, Iterable<?> iterable) {
        if (iterable == null) {
            throw CommonErrors.iterableToLookForIsNull();
        }
        Arrays.assertNotNull(info, array);
        Object[] values = Lists.newArrayList(iterable).toArray();
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        for (Object value : values) {
            if (this.arrayContains(array, value)) continue;
            notFound.add(value);
        }
        if (!notFound.isEmpty()) {
            throw failures.failure(info, ShouldContain.shouldContain(array, values, notFound, this.comparisonStrategy));
        }
    }

    void assertContains(AssertionInfo info, Failures failures, Object array, Object value, Index index) {
        Arrays.assertNotNull(info, array);
        this.assertNotEmpty(info, failures, array);
        CommonValidations.checkIndexValueIsValid(index, Arrays.sizeOf(array) - 1);
        Object actualElement = Array.get(array, index.value);
        if (this.areEqual(actualElement, value)) {
            return;
        }
        throw failures.failure(info, ShouldContainAtIndex.shouldContainAtIndex(array, value, index, Array.get(array, index.value), this.comparisonStrategy));
    }

    void assertNotEmpty(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        if (Arrays.isArrayEmpty(array)) {
            throw failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    void assertDoesNotContain(AssertionInfo info, Failures failures, Object array, Object value, Index index) {
        Arrays.assertNotNull(info, array);
        CommonValidations.checkIndexValueIsValid(index, Integer.MAX_VALUE);
        if (index.value >= Arrays.sizeOf(array)) {
            return;
        }
        if (this.areEqual(Array.get(array, index.value), value)) {
            throw failures.failure(info, ShouldNotContainAtIndex.shouldNotContainAtIndex(array, value, index, this.comparisonStrategy));
        }
    }

    void assertContainsOnly(AssertionInfo info, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info, actual, values)) {
            return;
        }
        Set<Object> notExpected = this.asSetWithoutDuplicatesAccordingToComparisonStrategy(actual);
        Set<Object> notFound = this.containsOnly(notExpected, values);
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            return;
        }
        throw failures.failure(info, ShouldContainOnly.shouldContainOnly(actual, values, notFound, notExpected, this.comparisonStrategy));
    }

    void assertContainsOnlyOnce(AssertionInfo info, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info, actual, values)) {
            return;
        }
        Set<Object> expected = this.asTreeSetWithoutDuplicatesAccordingToComparisonStrategy(Arrays.asList(values));
        List<Object> actualList = Arrays.asList(actual);
        Set<Object> actualSet = this.asTreeSetWithoutDuplicatesAccordingToComparisonStrategy(actualList);
        Iterable<?> duplicates = this.comparisonStrategy.duplicatesFrom(actualList);
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        LinkedHashSet<Object> notOnlyOnce = new LinkedHashSet<Object>();
        for (Object element : expected) {
            if (!actualSet.contains(element)) {
                notFound.add(element);
                continue;
            }
            if (!this.collectionContains(duplicates, element)) continue;
            notOnlyOnce.add(element);
        }
        if (notFound.isEmpty() && notOnlyOnce.isEmpty()) {
            return;
        }
        throw failures.failure(info, ShouldContainsOnlyOnce.shouldContainsOnlyOnce(actual, values, notFound, notOnlyOnce, this.comparisonStrategy));
    }

    private Set<Object> containsOnly(Set<Object> actual, Object values) {
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        for (Object o : this.asSetWithoutDuplicatesAccordingToComparisonStrategy(values)) {
            if (this.collectionContains(actual, o)) {
                this.collectionRemoves(actual, o);
                continue;
            }
            notFound.add(o);
        }
        return notFound;
    }

    private Set<Object> asSetWithoutDuplicatesAccordingToComparisonStrategy(Object array) {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        int size = Arrays.sizeOf(array);
        for (int i = 0; i < size; ++i) {
            Object element = Array.get(array, i);
            if (this.collectionContains(set, element)) continue;
            set.add(element);
        }
        return set;
    }

    private Set<Object> asTreeSetWithoutDuplicatesAccordingToComparisonStrategy(Iterable<Object> iterable) {
        TreeSet<Object> set = new TreeSet<Object>(this.getComparatorFromComparisonStrategy());
        for (Object element : iterable) {
            set.add(element);
        }
        return set;
    }

    private Comparator<Object> getComparatorFromComparisonStrategy() {
        Comparator<Object> comparator = this.getComparator();
        if (comparator == null) {
            comparator = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (Arrays.this.comparisonStrategy.areEqual(o1, o2)) {
                        return 0;
                    }
                    if (Arrays.this.comparisonStrategy.isGreaterThan(o1, o2)) {
                        return 1;
                    }
                    return -1;
                }
            };
        }
        return comparator;
    }

    private boolean collectionContains(Iterable<?> actual, Object value) {
        return this.comparisonStrategy.iterableContains(actual, value);
    }

    private void collectionRemoves(Collection<?> actual, Object value) {
        this.comparisonStrategy.iterableRemoves(actual, value);
    }

    void assertContainsSequence(AssertionInfo info, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info, actual, sequence)) {
            return;
        }
        int lastIndexWhereSequeceCanBeFound = Arrays.sizeOf(actual) - Arrays.sizeOf(sequence);
        for (int actualIndex = 0; actualIndex <= lastIndexWhereSequeceCanBeFound; ++actualIndex) {
            if (!this.containsSequenceAtGivenIndex(actualIndex, actual, sequence)) continue;
            return;
        }
        throw failures.failure(info, ShouldContainSequence.shouldContainSequence(actual, sequence, this.comparisonStrategy));
    }

    private boolean containsSequenceAtGivenIndex(int actualStartIndex, Object actualArray, Object sequence) {
        int sequenceSize = Arrays.sizeOf(sequence);
        for (int i = 0; i < sequenceSize; ++i) {
            if (this.areEqual(Array.get(sequence, i), Array.get(actualArray, i + actualStartIndex))) continue;
            return false;
        }
        return true;
    }

    void assertContainsSubsequence(AssertionInfo info, Failures failures, Object actual, Object subsequence) {
        if (Arrays.commonChecks(info, actual, subsequence)) {
            return;
        }
        int sizeOfActual = Arrays.sizeOf(actual);
        int sizeOfSubsequence = Arrays.sizeOf(subsequence);
        int lastIndexWhereEndOfSubsequeceCanBeFound = sizeOfActual - sizeOfSubsequence;
        int subsequenceIndex = 0;
        for (int actualIndex = 0; actualIndex <= lastIndexWhereEndOfSubsequeceCanBeFound && subsequenceIndex < sizeOfSubsequence; ++actualIndex) {
            if (!this.areEqual(Array.get(actual, actualIndex), Array.get(subsequence, subsequenceIndex))) continue;
            ++subsequenceIndex;
            ++lastIndexWhereEndOfSubsequeceCanBeFound;
        }
        if (subsequenceIndex < sizeOfSubsequence) {
            throw failures.failure(info, ShouldContainSubsequence.shouldContainSubsequence(actual, subsequence, this.comparisonStrategy));
        }
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    void assertDoesNotContain(AssertionInfo info, Failures failures, Object array, Object values) {
        Arrays.checkIsNotNullAndNotEmpty(values);
        Arrays.assertNotNull(info, array);
        LinkedHashSet<Object> found = new LinkedHashSet<Object>();
        for (int i = 0; i < Arrays.sizeOf(values); ++i) {
            Object value = Array.get(values, i);
            if (!this.arrayContains(array, value)) continue;
            found.add(value);
        }
        if (found.isEmpty()) {
            return;
        }
        throw failures.failure(info, ShouldNotContain.shouldNotContain(array, values, found, this.comparisonStrategy));
    }

    private boolean arrayContains(Object array, Object value) {
        return this.comparisonStrategy.arrayContains(array, value);
    }

    void assertDoesNotHaveDuplicates(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        ArrayWrapperList wrapped = ArrayWrapperList.wrap(array);
        Iterable<?> duplicates = this.comparisonStrategy.duplicatesFrom(wrapped);
        if (Iterables.isNullOrEmpty(duplicates)) {
            return;
        }
        throw failures.failure(info, ShouldNotHaveDuplicates.shouldNotHaveDuplicates(array, duplicates, this.comparisonStrategy));
    }

    void assertStartsWith(AssertionInfo info, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info, actual, sequence)) {
            return;
        }
        int sequenceSize = Arrays.sizeOf(sequence);
        int arraySize = Arrays.sizeOf(actual);
        if (arraySize < sequenceSize) {
            throw this.arrayDoesNotStartWithSequence(info, failures, actual, sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            if (this.areEqual(Array.get(sequence, i), Array.get(actual, i))) continue;
            throw this.arrayDoesNotStartWithSequence(info, failures, actual, sequence);
        }
    }

    private static boolean commonChecks(AssertionInfo info, Object actual, Object sequence) {
        Arrays.checkIsNotNull(sequence);
        Arrays.assertNotNull(info, actual);
        if (Arrays.isArrayEmpty(actual) && Arrays.isArrayEmpty(sequence)) {
            return true;
        }
        Arrays.failIfEmptySinceActualIsNotEmpty(sequence);
        return false;
    }

    private AssertionError arrayDoesNotStartWithSequence(AssertionInfo info, Failures failures, Object array, Object sequence) {
        return failures.failure(info, ShouldStartWith.shouldStartWith(array, sequence, this.comparisonStrategy));
    }

    void assertEndsWith(AssertionInfo info, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info, actual, sequence)) {
            return;
        }
        int sequenceSize = Arrays.sizeOf(sequence);
        int arraySize = Arrays.sizeOf(actual);
        if (arraySize < sequenceSize) {
            throw this.arrayDoesNotEndWithSequence(info, failures, actual, sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            int sequenceIndex = sequenceSize - (i + 1);
            int arrayIndex = arraySize - (i + 1);
            if (this.areEqual(Array.get(sequence, sequenceIndex), Array.get(actual, arrayIndex))) continue;
            throw this.arrayDoesNotEndWithSequence(info, failures, actual, sequence);
        }
    }

    void assertContainsNull(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        if (!this.arrayContains(array, null)) {
            throw failures.failure(info, ShouldContainNull.shouldContainNull(array));
        }
    }

    void assertDoesNotContainNull(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        if (this.arrayContains(array, null)) {
            throw failures.failure(info, ShouldNotContainNull.shouldNotContainNull(array));
        }
    }

    public <E> void assertAre(AssertionInfo info, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        Arrays.assertNotNull(info, array);
        conditions.assertIsNotNull(condition);
        try {
            List<E> notSatisfiesCondition = this.elementsNotSatisfyingCondition(array, condition);
            if (!notSatisfiesCondition.isEmpty()) {
                throw failures.failure(info, ElementsShouldBe.elementsShouldBe(array, notSatisfiesCondition, condition));
            }
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    public <E> void assertAreNot(AssertionInfo info, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        Arrays.assertNotNull(info, array);
        conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.elementsSatisfyingCondition(array, condition);
            if (satisfiesCondition.isEmpty()) {
                return;
            }
            throw failures.failure(info, ElementsShouldNotBe.elementsShouldNotBe(array, satisfiesCondition, condition));
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    public <E> void assertHave(AssertionInfo info, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        Arrays.assertNotNull(info, array);
        conditions.assertIsNotNull(condition);
        try {
            List<E> notSatisfiesCondition = this.elementsNotSatisfyingCondition(array, condition);
            if (notSatisfiesCondition.isEmpty()) {
                return;
            }
            throw failures.failure(info, ElementsShouldHave.elementsShouldHave(array, notSatisfiesCondition, condition));
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    public <E> void assertHaveNot(AssertionInfo info, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        Arrays.assertNotNull(info, array);
        conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.elementsSatisfyingCondition(array, condition);
            if (satisfiesCondition.isEmpty()) {
                return;
            }
            throw failures.failure(info, ElementsShouldNotHave.elementsShouldNotHave(array, satisfiesCondition, condition));
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    public <E> void assertAreAtLeast(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        Arrays.assertNotNull(info, array);
        conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.elementsSatisfyingCondition(array, condition);
            if (satisfiesCondition.size() >= times) {
                return;
            }
            throw failures.failure(info, ElementsShouldBeAtLeast.elementsShouldBeAtLeast(array, times, condition));
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    public <E> void assertAreAtMost(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        Arrays.assertNotNull(info, array);
        conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.elementsSatisfyingCondition(array, condition);
            if (satisfiesCondition.size() <= times) {
                return;
            }
            throw failures.failure(info, ElementsShouldBeAtMost.elementsShouldBeAtMost(array, times, condition));
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    public <E> void assertAreExactly(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        Arrays.assertNotNull(info, array);
        conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.elementsSatisfyingCondition(array, condition);
            if (satisfiesCondition.size() == times) {
                return;
            }
            throw failures.failure(info, ElementsShouldBeExactly.elementsShouldBeExactly(array, times, condition));
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    public <E> void assertHaveAtLeast(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        Arrays.assertNotNull(info, array);
        conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.elementsSatisfyingCondition(array, condition);
            if (satisfiesCondition.size() >= times) {
                return;
            }
            throw failures.failure(info, ElementsShouldHaveAtLeast.elementsShouldHaveAtLeast(array, times, condition));
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    public <E> void assertHaveAtMost(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        Arrays.assertNotNull(info, array);
        conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.elementsSatisfyingCondition(array, condition);
            if (satisfiesCondition.size() <= times) {
                return;
            }
            throw failures.failure(info, ElementsShouldHaveAtMost.elementsShouldHaveAtMost(array, times, condition));
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    public <E> void assertHaveExactly(AssertionInfo info, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        Arrays.assertNotNull(info, array);
        conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.elementsSatisfyingCondition(array, condition);
            if (satisfiesCondition.size() == times) {
                return;
            }
            throw failures.failure(info, ElementsShouldHaveExactly.elementsShouldHaveExactly(array, times, condition));
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    private <E> List<E> elementsNotSatisfyingCondition(Object array, Condition<E> condition) {
        LinkedList<Object> elementsNotSatisfyingCondition = new LinkedList<Object>();
        int arraySize = Arrays.sizeOf(array);
        for (int i = 0; i < arraySize; ++i) {
            Object o = Array.get(array, i);
            if (condition.matches(o)) continue;
            elementsNotSatisfyingCondition.add(o);
        }
        return elementsNotSatisfyingCondition;
    }

    private <E> List<E> elementsSatisfyingCondition(Object array, Condition<E> condition) {
        LinkedList<Object> elementsSatisfyingCondition = new LinkedList<Object>();
        int arraySize = Arrays.sizeOf(array);
        for (int i = 0; i < arraySize; ++i) {
            Object o = Array.get(array, i);
            if (!condition.matches(o)) continue;
            elementsSatisfyingCondition.add(o);
        }
        return elementsSatisfyingCondition;
    }

    void assertIsSorted(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            Comparator<?> comparator = ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
            Arrays.assertIsSortedAccordingToComparator(info, failures, array, comparator);
            return;
        }
        if (Arrays.sizeOf(array) == 0) {
            return;
        }
        Arrays.assertThatArrayComponentTypeIsSortable(info, failures, array);
        try {
            Comparable<Object>[] comparableArray = Arrays.arrayOfComparableItems(array);
            if (comparableArray.length <= 1) {
                return;
            }
            for (int i = 0; i < comparableArray.length - 1; ++i) {
                if (comparableArray[i].compareTo(comparableArray[i + 1]) <= 0) continue;
                throw failures.failure(info, ShouldBeSorted.shouldBeSorted(i, array));
            }
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ShouldBeSorted.shouldHaveMutuallyComparableElements(array));
        }
    }

    static <T> void assertIsSortedAccordingToComparator(AssertionInfo info, Failures failures, Object array, Comparator<T> comparator) {
        Arrays.assertNotNull(info, array);
        if (comparator == null) {
            throw new NullPointerException("The given comparator should not be null");
        }
        try {
            List<T> arrayAsList = Arrays.asList(array);
            if (arrayAsList.size() == 0) {
                return;
            }
            if (arrayAsList.size() == 1) {
                comparator.compare(arrayAsList.get(0), arrayAsList.get(0));
                return;
            }
            for (int i = 0; i < arrayAsList.size() - 1; ++i) {
                if (comparator.compare(arrayAsList.get(i), arrayAsList.get(i + 1)) <= 0) continue;
                throw failures.failure(info, ShouldBeSorted.shouldBeSortedAccordingToGivenComparator(i, array, comparator));
            }
        }
        catch (ClassCastException e) {
            throw failures.failure(info, ShouldBeSorted.shouldHaveComparableElementsAccordingToGivenComparator(array, comparator));
        }
    }

    private static <T> List<T> asList(Object array) {
        if (array == null) {
            return null;
        }
        if (!org.assertj.core.util.Arrays.isArray(array)) {
            throw new IllegalArgumentException("The object should be an array");
        }
        int length = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    private static Comparable<Object>[] arrayOfComparableItems(Object array) {
        ArrayWrapperList arrayWrapperList = ArrayWrapperList.wrap(array);
        Comparable[] arrayOfComparableItems = new Comparable[arrayWrapperList.size()];
        for (int i = 0; i < arrayWrapperList.size(); ++i) {
            arrayOfComparableItems[i] = (Comparable)arrayWrapperList.get(i);
        }
        return arrayOfComparableItems;
    }

    private static void assertThatArrayComponentTypeIsSortable(AssertionInfo info, Failures failures, Object array) {
        ArrayWrapperList arrayAsList = ArrayWrapperList.wrap(array);
        Class<?> arrayComponentType = arrayAsList.getComponentType();
        if (arrayComponentType.isPrimitive()) {
            return;
        }
        if (!Comparable.class.isAssignableFrom(arrayComponentType)) {
            throw failures.failure(info, ShouldBeSorted.shouldHaveMutuallyComparableElements(array));
        }
    }

    private static void checkIsNotNullAndNotEmpty(Object values) {
        Arrays.checkIsNotNull(values);
        if (Arrays.isArrayEmpty(values)) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    private static void checkIsNotNull(Object values) {
        if (values == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    private static boolean isArrayEmpty(Object array) {
        return Arrays.sizeOf(array) == 0;
    }

    private AssertionError arrayDoesNotEndWithSequence(AssertionInfo info, Failures failures, Object array, Object sequence) {
        return failures.failure(info, ShouldEndWith.shouldEndWith(array, sequence, this.comparisonStrategy));
    }

    private static void assertNotNull(AssertionInfo info, Object array) {
        Objects.instance().assertNotNull(info, array);
    }

    private static int sizeOf(Object array) {
        return Array.getLength(array);
    }

    private static void failIfEmptySinceActualIsNotEmpty(Object values) {
        if (Arrays.isArrayEmpty(values)) {
            throw new AssertionError((Object)"actual is not empty while group of values to look for is.");
        }
    }
}

