/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.net.URL;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Urls;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractUrlAssert<S extends AbstractUrlAssert<S>>
extends AbstractAssert<S, URL> {
    @VisibleForTesting
    protected Urls urls = Urls.instance();

    protected AbstractUrlAssert(URL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S hasProtocol(String expected) {
        this.urls.assertHasProtocol(this.info, (URL)this.actual, expected);
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasPath(String expected) {
        this.urls.assertHasPath(this.info, (URL)this.actual, expected);
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasNoPath() {
        this.urls.assertHasPath(this.info, (URL)this.actual, "");
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasPort(int expected) {
        this.urls.assertHasPort(this.info, (URL)this.actual, expected);
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasNoPort() {
        this.urls.assertHasPort(this.info, (URL)this.actual, -1);
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasHost(String expected) {
        this.urls.assertHasHost(this.info, (URL)this.actual, expected);
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasAuthority(String expected) {
        this.urls.assertHasAuthority(this.info, (URL)this.actual, expected);
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasQuery(String expected) {
        this.urls.assertHasQuery(this.info, (URL)this.actual, expected);
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasNoQuery() {
        this.urls.assertHasQuery(this.info, (URL)this.actual, null);
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasAnchor(String expected) {
        this.urls.assertHasAnchor(this.info, (URL)this.actual, expected);
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasNoAnchor() {
        this.urls.assertHasAnchor(this.info, (URL)this.actual, null);
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasUserInfo(String expected) {
        this.urls.assertHasUserInfo(this.info, (URL)this.actual, expected);
        return (S)((AbstractUrlAssert)this.myself);
    }

    public S hasNoUserInfo() {
        this.urls.assertHasUserInfo(this.info, (URL)this.actual, null);
        return (S)((AbstractUrlAssert)this.myself);
    }
}

